package fr.xtof54.scrabble;

import android.content.Context;
import android.content.res.AssetManager;
import android.os.Bundle;
import android.os.Environment;
import android.support.v4.app.FragmentActivity;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

import java.io.*;
import java.util.ArrayList;
import java.util.Arrays;

public class ScrabbleActivity extends FragmentActivity {
    public static File appdir=null;
    public static ScrabbleActivity main;

    private WebView wv;
    private int lettreChoisie =0;
    private boolean isStar = false;
    private ArrayList<Joueur> joueurs = new ArrayList<Joueur>();
    private int playerShown=0;
    private int buttonUsed=-1;
    private String nom_partie = null;

    private final int[] buts = {R.id.buttonLettre1,R.id.buttonLettre2,R.id.buttonLettre3,R.id.buttonLettre4,R.id.buttonLettre5,R.id.buttonLettre6,R.id.buttonLettre7};
    private final int OFFSET_REMOVE = 50;
    private ArrayList<Integer> lettreposees = new ArrayList<Integer>();
    private myWebViewClient webview;

    private boolean redrawLetters = false;

    private void reset() {
        nom_partie=null;
        Pioche.getPioche().reset();
        // init with only 1 player
        joueurs.clear();
        joueurs.add(new Joueur());
        playerShown=0;
        PlateauNoGui.getPlateau().reset();
        showBoard();
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                buttonsLettres();
                otherButtons();
            }
        });
    }

    /**
     * Called when the activity is first created.
     */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        System.out.println("scrab on create");
        prepareSDcard();

        initGUI();
        reset();
        System.out.println("scrab init done");
        main = this;
    }

    @Override
    public void onStart() {
        super.onStart();
        redrawLetters=true;
        loadState();
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.main, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case R.id.restart:
                reset();
                return true;
            case R.id.preset:
                nom_partie=null;
                Pioche.getPioche().choosePreset(getSupportFragmentManager());
                return true;
            default:
                return super.onOptionsItemSelected(item);
        }
    }

    public void endPreset() {
        joueurs.clear();
        joueurs.add(new Joueur());
        playerShown=0;
        PlateauNoGui.getPlateau().reset();
        showBoard();
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                buttonsLettres();
                otherButtons();
            }
        });
    }

    private void loadState() {
        File d = new File(appdir+"/");
        File[] fs = d.listFiles(new FilenameFilter() {
            @Override
            public boolean accept(File file, String s) {
                return (s.startsWith("partie"));
            }
        });
        System.out.println("loadstate "+fs.length);
        if (fs==null||fs.length==0) return;
        int[] times = new int[fs.length];
        for (int i=0;i<times.length;i++) {
            int j=fs[i].getName().indexOf("partie");
            times[i]=Integer.parseInt(fs[i].getName().substring(j+6));
        }
        Arrays.sort(times);
        int last=times[times.length-1];

        nom_partie="partie"+last;
        final String fd = appdir+"/"+nom_partie;
        try {
            System.out.println("loading "+fd);
            BufferedReader f = new BufferedReader(new FileReader(fd));
            String stmp = f.readLine(); // "nplayer #joueurs #curjoueur
            String[] ss = stmp.split(" ");
            int nj = Integer.parseInt(ss[1]);
            playerShown = Integer.parseInt(ss[2]);
            joueurs.clear();
            for (int i=0;i<nj;i++) joueurs.add(Joueur.load(f));
            buttonsLettres();
            PlateauNoGui.getPlateau().load(f);
            for (int[] l : PlateauNoGui.getPlateau().lettresPosees) {
                poseLettre(l[0],l[1],l[2]);
            }
            Pioche.getPioche().load(f);
            f.close();
            System.out.println("scrab game loaded from "+fd);
            GuiUtils.showMessage("Last game reloaded");
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void saveCurState() {
//        if (nom_partie==null) nom_partie="partie"+System.currentTimeMillis();
        if (nom_partie==null) nom_partie="partie2015";
        final String fd = appdir+"/"+nom_partie;
        try {
            PrintWriter f = new PrintWriter(new FileWriter(fd));
            f.println("nplayer "+joueurs.size()+" "+playerShown);
            for (int i=0;i<joueurs.size();i++) joueurs.get(i).save(f);
            PlateauNoGui.getPlateau().save(f);
            Pioche.getPioche().save(f);
            f.close();
            System.out.println("scrab game saved in "+fd);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void otherButtons() {
        {
            Button b = (Button)findViewById(R.id.buttonCancel);
            b.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    joueurs.get(playerShown).cancelLetters();
                    PlateauNoGui.getPlateau().resetLettresCliquees();
                    effaceLettresSurPlateau();
                    buttonsLettres();
                    lettreposees.clear();
                }
            });
        }
        {
            Button b = (Button)findViewById(R.id.buttonOK);
            b.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    int pts = PlateauNoGui.getPlateau().confirmLettres();
                    System.out.println("scrab pts " + pts);
                    if (pts<=0) {
                        joueurs.get(playerShown).cancelLetters();
                        PlateauNoGui.getPlateau().resetLettresCliquees();
                        effaceLettresSurPlateau();
                    } else {
                        joueurs.get(playerShown).finitCoup(pts);
                        int sc = joueurs.get(playerShown).getScore();
                        saveCurState();
                        TextView tt = (TextView)findViewById(R.id.textView);
                        tt.setText("Score: "+sc+" (+"+pts+")");
                        tt.invalidate();
                    }
                    buttonsLettres();
                    lettreposees.clear();
                }
            });
        }
        {
            Button b = (Button)findViewById(R.id.zoomin);
            b.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    WebView wv = (WebView)findViewById(R.id.web1);
                    wv.zoomIn();
                    wv.invalidate();
                }
            });
        }
        {
            Button b = (Button)findViewById(R.id.zoomout);
            b.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    WebView wv = (WebView)findViewById(R.id.web1);
                    wv.zoomOut();
                    wv.invalidate();
                }
            });
        }
    }

    private void buttonsLettres() {
        for (int i=0;i<7;i++) {
            final int buttonnum=i;
            Button b = (Button)findViewById(buts[i]);
            final char l = joueurs.get(playerShown).lettres[i];
            System.out.println("setting button "+i+" "+l);
            b.setText(""+l);
            b.invalidate();
            b.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    buttonUsed=buttonnum;
                    switch (l) {
                        case 'A': lettreChoisie =0; break;
                        case 'B': lettreChoisie =1; break;
                        case 'C': lettreChoisie =2; break;
                        case 'D': lettreChoisie =3; break;
                        case 'E': lettreChoisie =4; break;
                        case 'F': lettreChoisie =5; break;
                        case 'G': lettreChoisie =6; break;
                        case 'H': lettreChoisie =7; break;
                        case 'I': lettreChoisie =8; break;
                        case 'J': lettreChoisie =9; break;
                        case 'K': lettreChoisie =10; break;
                        case 'L': lettreChoisie =11; break;
                        case 'M': lettreChoisie =12; break;
                        case 'N': lettreChoisie =13; break;
                        case 'O': lettreChoisie =14; break;
                        case 'P': lettreChoisie =15; break;
                        case 'Q': lettreChoisie =16; break;
                        case 'R': lettreChoisie =17; break;
                        case 'S': lettreChoisie =18; break;
                        case 'T': lettreChoisie =19; break;
                        case 'U': lettreChoisie =20; break;
                        case 'V': lettreChoisie =21; break;
                        case 'W': lettreChoisie =22; break;
                        case 'X': lettreChoisie =23; break;
                        case 'Y': lettreChoisie =24; break;
                        case 'Z': lettreChoisie =25; break;
                        case '*': chooseStarLetter(); break;
                    }
                }
            });
        }
    }

    private void chooseStarLetter() {
        GuiUtils.askUser("msg inutile", new GuiUtils.UserFeedback() {
            @Override
            public void pressOK(String txt0) {
                if (txt0==null) {
                    lettreChoisie =-1; return;}
                String txt=txt0.trim().toUpperCase();
                if (txt.length()==0) {
                    lettreChoisie =-1; return;}
                char c=txt.charAt(0);
                if (!Character.isLetter(c)) {
                    lettreChoisie =-1; return;}
                switch (c) {
                    case 'A': lettreChoisie =0; break;
                    case 'B': lettreChoisie =1; break;
                    case 'C': lettreChoisie =2; break;
                    case 'D': lettreChoisie =3; break;
                    case 'E': lettreChoisie =4; break;
                    case 'F': lettreChoisie =5; break;
                    case 'G': lettreChoisie =6; break;
                    case 'H': lettreChoisie =7; break;
                    case 'I': lettreChoisie =8; break;
                    case 'J': lettreChoisie =9; break;
                    case 'K': lettreChoisie =10; break;
                    case 'L': lettreChoisie =11; break;
                    case 'M': lettreChoisie =12; break;
                    case 'N': lettreChoisie =13; break;
                    case 'O': lettreChoisie =14; break;
                    case 'P': lettreChoisie =15; break;
                    case 'Q': lettreChoisie =16; break;
                    case 'R': lettreChoisie =17; break;
                    case 'S': lettreChoisie =18; break;
                    case 'T': lettreChoisie =19; break;
                    case 'U': lettreChoisie =20; break;
                    case 'V': lettreChoisie =21; break;
                    case 'W': lettreChoisie =22; break;
                    case 'X': lettreChoisie =23; break;
                    case 'Y': lettreChoisie =24; break;
                    case 'Z': lettreChoisie =25; break;
                    default: lettreChoisie =-1; break;
                }
                if (lettreChoisie >=0) lettreChoisie +=30; // pour indiquer que c'est une STAR
            }

            @Override
            public void pressCancel() {
                lettreChoisie =-1;
            }
        }, getSupportFragmentManager());
    }

    public void showBoard() {
        String f=appdir+"/test.html";
        wv.loadUrl("file://" + f);
    }

    private class WebAppInterface {
        Context c;
        public WebAppInterface(Context ct) {
            c=ct;
        }
//        @JavascriptInterface
        public void msg1() {
            System.out.println("web android message 1");
        }
    }

    private void initGUI() {
        setContentView(R.layout.main);
        wv = (WebView)findViewById(R.id.web1);
        webview=new myWebViewClient();
        wv.setWebViewClient(webview);
//        wv.addJavascriptInterface(new WebAppInterface(this),"Android");
        wv.getSettings().setJavaScriptEnabled(true);
        wv.getSettings().setSupportZoom(true);

//        String myHTML = "<html><body><a href='androidcall01Ctiti'>Call Back to Android 01 with param 123456</a>my Content<p>my Content<p>my Content<p><a href='androidcall02|7890123'>Call Back to Android 01 with param 7890123</a></body></html>";
        // shouldOverrideUrlLoading() n'est pas appelé lorsqu'on charge la page avec loadDataWithBaseURL()
        // mais il est appele lorsqu'on clic depuis la page sur le lien androidcall01 ci-dessus.
        // peut-etre donc que shouldOverrideUrlLoading() n'est appelé que lorsqu'on change d'URL depuis la web page !
//        wv.loadDataWithBaseURL("about:blank", myHTML, "text/html", "utf-8", "");

//        showBoard();
    }

    private void copyFromAssets(String inputDir, File outputDir) {
        AssetManager mgr = getResources().getAssets();
        try {
            String[] fs = mgr.list(inputDir);
            for (String s : fs) {
                System.out.println("scrab found in assets "+s);
                try {
                    InputStream i = mgr.open(inputDir+"/"+s);
                    // this is a file
                    File f0 = new File(outputDir,s);
                    FileOutputStream f = new FileOutputStream(f0);
                    for (;;) {
                        int d = i.read();
                        if (d<0) break;
                        f.write(d);
                    }
                    f.close();
                    i.close();
                    System.out.println("scrab copied file: "+f0.getAbsolutePath());
                } catch (FileNotFoundException e) {
                    System.out.println("scrab error in copy "+e);
                    // this is a directory and not a file
                    File f = new File(outputDir,s);
                    f.mkdirs();
                    copyFromAssets(inputDir + "/" +s,f);
                }
            }
        } catch (IOException e) {
            e.printStackTrace();
            showMessage("DISK ERROR: "+e.toString());
        }
        System.out.println("endof copy");
    }

    private void prepareSDcard() {
        System.out.println("scrab preparesdcard");
        boolean mExternalStorageAvailable = false;
        boolean mExternalStorageWriteable = false;
        String state = Environment.getExternalStorageState();
        if (Environment.MEDIA_MOUNTED.equals(state)) {
            mExternalStorageAvailable = mExternalStorageWriteable = true;
        } else if (Environment.MEDIA_MOUNTED_READ_ONLY.equals(state)) {
            mExternalStorageAvailable = true;
            mExternalStorageWriteable = false;
        } else {
            mExternalStorageAvailable = mExternalStorageWriteable = false;
        }
        File d = null;
        if (mExternalStorageAvailable&&mExternalStorageWriteable) {
            d = getExternalCacheDir();
        }
        if (d==null) {
            d = getCacheDir();
        }
        if (d==null) {
            showMessage("scrab R/W ERROR sdcard");
        } else {
            System.out.println("scrabble cachedir "+d.getAbsolutePath());
            appdir = new File(d, "scrabble");
            if (!appdir.exists()) {
                appdir.mkdirs();
                copyFromAssets("board",appdir);
            } else {
                showMessage("app dir already setup");
            }
        }
        System.out.println("scrabapp appdir " + appdir);
    }

    public void showMessage(final String txt) {
        this.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                Toast.makeText(getBaseContext(), txt, Toast.LENGTH_LONG).show();
            }
        });
    }

    // --------------------------------------------------

    private class myWebViewClient extends WebViewClient {

        @Override
        public void onPageFinished(final WebView view, String url) {
            System.out.println("webview page finished loading " + url);
            if (redrawLetters) {
                for (int[] l : PlateauNoGui.getPlateau().lettresPosees) poseLettre(l[0],l[1],l[2]);
                redrawLetters=false;
            }
        }

        @Override
        public void onReceivedError(final WebView view, int e, String url, String er) {
            System.out.println("webview page received error " + url);
            System.out.println("ERROR= "+e+" "+er);
        }

        /**
         * cette methode n'est pas appelee lors du premier affichage. pourquoi ?
         * D'apres mes analyses, il semblerait que cette methode ne soit appellee que:
         * - lorsque le changement de "window.location" est lancé depuis l'intérieur de la WebView
         * - à la fin du processus d'affichage de la page, et non au moment où window.location est modifié !
         *   en particulier, cela veut dire qu'il est inutile de modifier plusieurs fois window.location à la suite,
         *   car seul le dernier sera réellement affiché.
         */
        @Override
        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            System.out.println("scrab mywebclient detecting command from javascript: "+url);
            url = url.toLowerCase();
            int i=url.indexOf("androidcall");
            if (i>=0) {
                // received an action from javascript
                if (url.substring(i).startsWith("androidcallmsg")) {
                    System.out.println("scrab webview msg "+url.substring(i).substring(14));
                    return true;
                } else if (url.substring(i).startsWith("androidcall01c:clicx")) {
                    System.out.println("received mouse clic");
                    // conversion des pixels en cases
                    int z=url.indexOf('y',i);
                    int x = Integer.parseInt(url.substring(i + 20, z));
                    int y = Integer.parseInt(url.substring(z+1));
                    int casex = (x-36)/21;
                    int casey = (y-38)/21;
                    if (lettreChoisie >=0) {
                        if (PlateauNoGui.getPlateau().clickUser(casex, casey, lettreChoisie))
                            poseLettre(view, casex, casey);
                        else {
                            SoundUtils.playError();
                        }
                    }
                }
                System.out.println("WARNING: unknown androidcall01 from javascript !");
                return true;
            } else {
                // its not an android call back
                // let the browser navigate normally
                return false;
            }
        }
    }

    private void effaceLettresSurPlateau() {
        WebView view = (WebView)findViewById(R.id.web1);
        for (int z0 : lettreposees) {
            int z=z0;
            if (z%100>=30) {
                // c'est une lettre STAR
                z-=30;
            }
            view.loadUrl("javascript:scrab.autoPlayers[0].detDelLettre("+z+")");
        }
    }
    private void poseLettre(WebView view,int casex, int casey) {
        System.out.println("scrab pose lettre "+buttonUsed);
        if (buttonUsed<0) return;
        if (!joueurs.get(playerShown).usingLettre(buttonUsed)) return;
        System.out.println("scran set button lettre");
        Button b = (Button)findViewById(buts[buttonUsed]);
        b.setText(" ");
        b.invalidate();
        buttonUsed=-1;
        int z=casex*10000+casey*100+ lettreChoisie;
        lettreposees.add(z);
        if (lettreChoisie >=30) z-=30; // c'est une lettre issue de STAR
        System.out.println("scrab call webview lettre " + z);
        view.loadUrl("javascript:scrab.autoPlayers[0].detShowLettre("+z+")");
        System.out.println("scrab poselettre fin");
    }

    void poseLettre(int casex, int casey, int l) {
        int ll=l;
        if (l>=30) ll-=30; // c'est une lettre issue de STAR
        final int z=casex*10000+casey*100+ll;
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                ((WebView)findViewById(R.id.web1)).loadUrl("javascript:scrab.autoPlayers[0].detShowLettre(" + z + ")");
            }
        });
    }

}
