/*
 * Decompiled with CFR 0.152.
 */
package fr.ybo.database.modele;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import fr.ybo.database.DataBaseException;
import fr.ybo.database.annotation.Entity;
import fr.ybo.database.modele.Column;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Table {
    private final List<Column> columns = new ArrayList<Column>();
    private String name;
    private String primaryKeyWhere;
    private String[] columnsNames;
    private final Constructor<?> constructor;
    private Boolean autoIncrement = null;
    private Column autoIncrementColumn = null;

    Table(Class<?> clazz) throws DataBaseException {
        Entity table = clazz.getAnnotation(Entity.class);
        if (table == null) {
            throw new DataBaseException("The class " + clazz.getSimpleName() + " don't contains the annotation @Table");
        }
        this.name = table.name();
        if ("".equals(this.name)) {
            this.name = clazz.getSimpleName();
        }
        for (Field field : clazz.getDeclaredFields()) {
            if (field.getAnnotation(fr.ybo.database.annotation.Column.class) == null) continue;
            this.columns.add(new Column(field, this.name));
        }
        try {
            this.constructor = clazz.getConstructor(null);
        }
        catch (SecurityException e) {
            throw new DataBaseException(e);
        }
        catch (NoSuchMethodException e) {
            throw new DataBaseException(e);
        }
    }

    public Table(Table table) {
        for (Column colonne : table.columns) {
            this.columns.add(new Column(colonne));
        }
        this.name = table.name;
        this.primaryKeyWhere = table.primaryKeyWhere;
        this.columnsNames = table.columnsNames;
        this.constructor = table.constructor;
    }

    public void addSuffixeToTableName(String suffix) {
        this.name = this.name + '_' + suffix;
        for (Column colonne : this.columns) {
            colonne.setTableName(this.name);
        }
    }

    public void createTable(SQLiteDatabase db) {
        StringBuilder requete = new StringBuilder();
        requete.append("CREATE TABLE ");
        requete.append(this.name);
        requete.append(" (");
        ArrayList<String> indexes = new ArrayList<String>(2);
        StringBuilder primaryKeys = new StringBuilder();
        boolean first = true;
        boolean hasAutoIncrement = false;
        for (Column colonne : this.columns) {
            if (!first) {
                requete.append(',');
            }
            requete.append(colonne.getSqlDefinition());
            if (colonne.isPrimaryKey()) {
                if (hasAutoIncrement) {
                    throw new DataBaseException("Only one primary key with an autoIncrement by table");
                }
                if (colonne.isAutoIncrement()) {
                    requete.append(" PRIMARY KEY AUTOINCREMENT ");
                    hasAutoIncrement = true;
                } else {
                    if (primaryKeys.length() == 0) {
                        primaryKeys.append(",PRIMARY KEY (");
                    } else {
                        primaryKeys.append(',');
                    }
                    primaryKeys.append(colonne.getName());
                }
            }
            if (colonne.isNotNull()) {
                requete.append("NOT NULL");
            }
            if (colonne.isIndexed()) {
                indexes.add(colonne.getIndexSqlDef());
            }
            first = false;
        }
        if (primaryKeys.length() > 0) {
            if (hasAutoIncrement) {
                throw new DataBaseException("Only one primary key with an autoIncrement by table");
            }
            requete.append(primaryKeys.toString());
            requete.append(')');
        }
        requete.append(");");
        db.execSQL(requete.toString());
        for (String requeteIndex : indexes) {
            db.execSQL(requeteIndex);
        }
    }

    void delete(SQLiteDatabase db) {
        db.delete(this.name, null, null);
    }

    <Entity> void delete(SQLiteDatabase db, Entity entity) throws DataBaseException {
        List<String> where = this.generatePrimaryKeyWhere(entity);
        db.delete(this.name, this.getPrimaryKeyWhere(), where.toArray(new String[where.size()]));
    }

    <Entity> void update(SQLiteDatabase db, Entity entity) throws DataBaseException {
        List<String> where = this.generatePrimaryKeyWhere(entity);
        ContentValues values = new ContentValues();
        for (Column colonne : this.columns) {
            if (colonne.isPrimaryKey()) continue;
            colonne.addValue(values, entity);
        }
        db.update(this.name, values, this.getPrimaryKeyWhere(), where.toArray(new String[where.size()]));
    }

    public void dropTable(SQLiteDatabase db) {
        StringBuilder requete = new StringBuilder();
        requete.append("DROP TABLE IF EXISTS ");
        requete.append(this.name);
        requete.append(';');
        db.execSQL(requete.toString());
    }

    private <Entity> List<String> generatePrimaryKeyWhere(Entity entity) throws DataBaseException {
        ArrayList<String> whereArgs = new ArrayList<String>(3);
        for (Column colonne : this.columns) {
            if (!colonne.isPrimaryKey()) continue;
            whereArgs.add(colonne.getValueToString(entity));
        }
        return whereArgs;
    }

    private String[] getColumns() {
        if (this.columnsNames == null) {
            this.columnsNames = new String[this.columns.size()];
            for (int count = 0; count < this.columns.size(); ++count) {
                this.columnsNames[count] = this.columns.get(count).getName();
            }
        }
        return this.columnsNames;
    }

    public String getName() {
        return this.name;
    }

    private Object getNewEntite() throws DataBaseException {
        try {
            return this.constructor.newInstance(null);
        }
        catch (IllegalArgumentException e) {
            throw new DataBaseException(e);
        }
        catch (InstantiationException e) {
            throw new DataBaseException(e);
        }
        catch (IllegalAccessException e) {
            throw new DataBaseException(e);
        }
        catch (InvocationTargetException e) {
            throw new DataBaseException(e);
        }
    }

    private boolean hasAutoIncrement() {
        if (this.autoIncrement == null) {
            this.autoIncrement = false;
            for (Column column : this.columns) {
                if (!column.isAutoIncrement()) continue;
                this.autoIncrement = true;
                this.autoIncrementColumn = column;
                break;
            }
        }
        return this.autoIncrement;
    }

    private <Entity> void setAutoIncrementColumn(Entity entity, long rowId) {
        if (this.hasAutoIncrement()) {
            this.autoIncrementColumn.setValue(entity, rowId);
        }
    }

    private String getPrimaryKeyWhere() {
        if (this.primaryKeyWhere == null) {
            StringBuilder where = new StringBuilder();
            boolean first = true;
            for (Column colonne : this.columns) {
                if (!colonne.isPrimaryKey()) continue;
                if (!first) {
                    where.append(" AND ");
                }
                where.append(colonne.getName());
                where.append(" = :");
                where.append(colonne.getName());
                first = false;
            }
            this.primaryKeyWhere = where.toString();
        }
        return this.primaryKeyWhere;
    }

    public <Entity> Entity insert(SQLiteDatabase db, Entity entity) throws DataBaseException {
        ContentValues values = new ContentValues();
        for (Column colonne : this.columns) {
            colonne.addValue(values, entity);
        }
        long rowId = db.insertOrThrow(this.name, null, values);
        this.setAutoIncrementColumn(entity, rowId);
        return entity;
    }

    <Entite> List<Entite> select(SQLiteDatabase db, Entite entite, String selectionPlus, Collection<String> selectArgsPlus, String orderBy) throws DataBaseException {
        String selection;
        ArrayList<Object> entites = new ArrayList<Object>();
        StringBuilder whereClause = new StringBuilder();
        ArrayList<String> selectionArgsList = new ArrayList<String>(selectArgsPlus == null ? 0 : selectArgsPlus.size());
        if (entite != null) {
            for (Column colonne : this.columns) {
                colonne.appendWhereIfNotNull(whereClause, entite, selectionArgsList);
            }
        }
        if (selectionPlus != null) {
            whereClause.append(" AND (");
            whereClause.append(selectionPlus);
            whereClause.append(')');
        }
        String string = selection = whereClause.length() > 0 ? whereClause.toString() : null;
        if (selectArgsPlus != null) {
            selectionArgsList.addAll(selectArgsPlus);
        }
        String[] selectionArgs = selection == null ? null : selectionArgsList.toArray(new String[selectionArgsList.size()]);
        Cursor cursor = db.query(this.name, this.getColumns(), selection, selectionArgs, null, null, orderBy);
        while (cursor.moveToNext()) {
            Object newEntite = this.getNewEntite();
            for (Column colonne : this.columns) {
                colonne.completeEntity(cursor, newEntite);
            }
            entites.add(newEntite);
        }
        cursor.close();
        return entites;
    }
}

