/*
 * Decompiled with CFR 0.152.
 */
package fr.ybo.moteurcsv.modele;

import fr.ybo.moteurcsv.exception.MoteurCsvException;
import fr.ybo.moteurcsv.modele.ChampCsv;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;

public class ClassCsv {
    private final String separateur;
    private final Class<?> clazz;
    private Constructor<?> contructeur;
    private final Map<String, ChampCsv> mapOfFields = new HashMap<String, ChampCsv>(5);
    private final Map<String, Integer> ordres = new HashMap<String, Integer>();
    private String separateurWithoutEscape = null;

    public ClassCsv(String separateur, Class<?> clazz) {
        this.separateur = separateur;
        this.clazz = clazz;
        try {
            this.contructeur = clazz.getDeclaredConstructor(null);
        }
        catch (Exception e) {
            throw new MoteurCsvException("Erreur a la r\u00e9cup\u00e9ration du constructeur de " + clazz.getSimpleName(), e);
        }
    }

    public ChampCsv getChampCsv(String nomCsv) {
        return this.mapOfFields.get(nomCsv);
    }

    public Iterable<String> getNomChamps() {
        return this.mapOfFields.keySet();
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public Constructor<?> getContructeur() {
        return this.contructeur;
    }

    public String getSeparateur() {
        return this.separateur;
    }

    public String getSeparateurWithoutEscape() {
        if (this.separateurWithoutEscape == null) {
            this.separateurWithoutEscape = this.separateur.replaceAll("\\\\", "");
        }
        return this.separateurWithoutEscape;
    }

    public void setChampCsv(String nomCsv, ChampCsv champCsv) {
        this.mapOfFields.put(nomCsv, champCsv);
    }

    public void putOrdre(String nomCsv, int ordre) {
        this.ordres.put(nomCsv, ordre);
    }

    public int getOrdre(String nomCsv) {
        return this.ordres.get(nomCsv);
    }
}

