/*
 * Decompiled with CFR 0.152.
 */
package fr.ybo.database.modele;

import android.database.sqlite.SQLiteDatabase;
import fr.ybo.database.DataBaseException;
import fr.ybo.database.modele.Table;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Base {
    private final Map<Class<?>, Table> mapClassTable = new HashMap(10);

    public Base(Iterable<Class<?>> classes) throws DataBaseException {
        for (Class<?> clazz : classes) {
            this.mapClassTable.put(clazz, new Table(clazz));
        }
    }

    public void createDataBase(SQLiteDatabase db) {
        for (Table table : this.mapClassTable.values()) {
            table.createTable(db);
        }
    }

    public <Entity> void update(SQLiteDatabase db, Entity entity) throws DataBaseException {
        Class<?> clazz = entity.getClass();
        if (!this.mapClassTable.containsKey(clazz)) {
            throw new DataBaseException("The class " + clazz.getSimpleName() + " is not defined in the database.");
        }
        this.mapClassTable.get(clazz).update(db, entity);
    }

    public <Entity> void delete(SQLiteDatabase db, Entity entity) throws DataBaseException {
        Class<?> clazz = entity.getClass();
        if (!this.mapClassTable.containsKey(clazz)) {
            throw new DataBaseException("The class " + clazz.getSimpleName() + " is not defined in the database.");
        }
        this.mapClassTable.get(clazz).delete(db, entity);
    }

    public <Entity> void deleteAll(SQLiteDatabase db, Class<Entity> clazz) throws DataBaseException {
        if (!this.mapClassTable.containsKey(clazz)) {
            throw new DataBaseException("The class " + clazz.getSimpleName() + " is not defined in the database.");
        }
        this.mapClassTable.get(clazz).delete(db);
    }

    public void dropDataBase(SQLiteDatabase db) {
        for (Table table : this.mapClassTable.values()) {
            db.execSQL("DROP TABLE IF EXISTS " + table.getName());
        }
    }

    public Table getTable(Class<?> clazz) throws DataBaseException {
        if (!this.mapClassTable.containsKey(clazz)) {
            throw new DataBaseException("The class " + clazz.getSimpleName() + " is not defined in the database.");
        }
        return new Table(this.mapClassTable.get(clazz));
    }

    public <Entity> Entity insert(SQLiteDatabase db, Entity entity) throws DataBaseException {
        Class<?> clazz = entity.getClass();
        if (!this.mapClassTable.containsKey(clazz)) {
            throw new DataBaseException("The class " + clazz.getSimpleName() + " is not defined in the database.");
        }
        return this.mapClassTable.get(clazz).insert(db, entity);
    }

    public <Entite> List<Entite> select(SQLiteDatabase db, Entite entite, String selection, Collection<String> selectionArgs, String orderBy) throws DataBaseException {
        Class<?> clazz = entite.getClass();
        if (!this.mapClassTable.containsKey(clazz)) {
            throw new DataBaseException("The class " + clazz.getSimpleName() + " is not defined in the database.");
        }
        return this.mapClassTable.get(clazz).select(db, entite, selection, selectionArgs, orderBy);
    }

    public <Entity> List<Entity> selectAll(SQLiteDatabase db, Class<Entity> clazz) throws DataBaseException {
        if (!this.mapClassTable.containsKey(clazz)) {
            throw new DataBaseException("The class " + clazz.getSimpleName() + " is not defined in the database.");
        }
        return this.mapClassTable.get(clazz).select(db, null, null, null, null);
    }
}

