/*
 * Decompiled with CFR 0.152.
 */
package fr.ybo.opentripplanner.client.modele;

import fr.ybo.opentripplanner.client.modele.OptimizeType;
import fr.ybo.opentripplanner.client.modele.TraverseModeSet;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Request {
    private static String FROM = "fromPlace";
    private static String TO = "toPlace";
    private static String DATE = "date";
    private static String TIME = "time";
    private static String MAX_WALK_DISTANCE = "maxWalkDistance";
    private static String OPTIMIZE = "optimize";
    private static String MODE = "mode";
    private static String NUMBER_ITINERARIES = "numItineraries";
    private static String SHOW_INTERMEDIATE_STOPS = "showIntermediateStops";
    private static String ARRIVE_BY = "arriveBy";
    private static String WALK_SPEED = "walkSpeed";
    private static String WHEELCHAIR = "wheelchair";
    private static String MIN_TRANSFER_TIME = "minTransferTime";
    private static SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("MM-dd-yyyy");
    private static SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("HH:mm:ss");
    private Double fromPlaceLatitude;
    private Double fromPlaceLongitude;
    private Double toPlaceLatitude;
    private Double toPlaceLongitude;
    private Date date;
    private Boolean arriveBy;
    private Boolean wheelchair;
    private Double maxWalkDistance;
    private Double walkSpeed;
    private OptimizeType optimize;
    private TraverseModeSet modes;
    private Integer minTransferTime;
    private Integer numItineraries;
    private Boolean showIntermediateStops;
    private StringBuilder stringBuilder;
    private boolean firstParam;

    public Request(Double fromPlaceLatitude, Double fromPlaceLongitude, Double toPlaceLatitude, Double toPlaceLongitude, Date date) {
        this.fromPlaceLatitude = fromPlaceLatitude;
        this.fromPlaceLongitude = fromPlaceLongitude;
        this.toPlaceLatitude = toPlaceLatitude;
        this.toPlaceLongitude = toPlaceLongitude;
        this.date = date;
    }

    public void setArriveBy(Boolean arriveBy) {
        this.arriveBy = arriveBy;
    }

    public void setWheelchair(Boolean wheelchair) {
        this.wheelchair = wheelchair;
    }

    public void setMaxWalkDistance(Double maxWalkDistance) {
        this.maxWalkDistance = maxWalkDistance;
    }

    public void setWalkSpeed(Double walkSpeed) {
        this.walkSpeed = walkSpeed;
    }

    public void setOptimize(OptimizeType optimize) {
        this.optimize = optimize;
    }

    public void setModes(TraverseModeSet modes) {
        this.modes = modes;
    }

    public void setMinTransferTime(Integer minTransferTime) {
        this.minTransferTime = minTransferTime;
    }

    public void setNumItineraries(Integer numItineraries) {
        this.numItineraries = numItineraries;
    }

    public void setShowIntermediateStops(Boolean showIntermediateStops) {
        this.showIntermediateStops = showIntermediateStops;
    }

    private void appendToUrl(String param, Object value) {
        if (value != null) {
            this.appendToUrl(param, value.toString());
        }
    }

    private void appendToUrl(String param, String value) {
        if (value == null) {
            return;
        }
        if (!this.firstParam) {
            this.stringBuilder.append('&');
        }
        this.stringBuilder.append(param);
        this.stringBuilder.append('=');
        this.stringBuilder.append(value);
        this.firstParam = false;
    }

    private String latLonToString(Double latitude, Double longitude) {
        if (latitude == null || longitude == null) {
            return null;
        }
        return "" + latitude + ',' + longitude;
    }

    private synchronized String formatDate() {
        if (this.date == null) {
            return null;
        }
        return DATE_FORMAT.format(this.date);
    }

    private synchronized String formatTime() {
        if (this.date == null) {
            return null;
        }
        return TIME_FORMAT.format(this.date);
    }

    public String constructUrl(String urlBase) {
        this.firstParam = true;
        this.stringBuilder = new StringBuilder(urlBase);
        this.stringBuilder.append('?');
        this.appendToUrl(FROM, this.latLonToString(this.fromPlaceLatitude, this.fromPlaceLongitude));
        this.appendToUrl(TO, this.latLonToString(this.toPlaceLatitude, this.toPlaceLongitude));
        this.appendToUrl(DATE, this.formatDate());
        this.appendToUrl(TIME, this.formatTime());
        this.appendToUrl(ARRIVE_BY, this.arriveBy);
        this.appendToUrl(WHEELCHAIR, this.wheelchair);
        this.appendToUrl(MAX_WALK_DISTANCE, this.maxWalkDistance);
        this.appendToUrl(WALK_SPEED, this.walkSpeed);
        this.appendToUrl(OPTIMIZE, (Object)this.optimize);
        this.appendToUrl(MODE, this.modes);
        this.appendToUrl(MIN_TRANSFER_TIME, this.minTransferTime);
        this.appendToUrl(NUMBER_ITINERARIES, this.numItineraries);
        this.appendToUrl(SHOW_INTERMEDIATE_STOPS, this.showIntermediateStops);
        return this.stringBuilder.toString();
    }

    public String toString() {
        return "Request [fromPlaceLatitude=" + this.fromPlaceLatitude + ", fromPlaceLongitude=" + this.fromPlaceLongitude + ", toPlaceLatitude=" + this.toPlaceLatitude + ", toPlaceLongitude=" + this.toPlaceLongitude + ", date=" + this.date + ", arriveBy=" + this.arriveBy + ", wheelchair=" + this.wheelchair + ", maxWalkDistance=" + this.maxWalkDistance + ", walkSpeed=" + this.walkSpeed + ", optimize=" + (Object)((Object)this.optimize) + ", modes=" + this.modes + ", minTransferTime=" + this.minTransferTime + ", numItineraries=" + this.numItineraries + ", showIntermediateStops=" + this.showIntermediateStops + ", stringBuilder=" + this.stringBuilder + ", firstParam=" + this.firstParam + "]";
    }
}

