/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.geocoder;

import com.google.code.geocoder.model.GeocodeResponse;
import com.google.code.geocoder.model.GeocoderRequest;
import com.google.code.geocoder.model.LatLng;
import com.google.code.geocoder.model.LatLngBounds;
import com.google.code.geocoder.util.StringUtils;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;

public final class Geocoder {
    private Geocoder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GeocodeResponse geocode(GeocoderRequest geocoderRequest) {
        GeocodeResponse reponse = null;
        try {
            String urlString = Geocoder.getURL(geocoderRequest);
            Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
            URL url = new URL(urlString);
            InputStreamReader reader = new InputStreamReader(url.openStream(), "UTF-8");
            try {
                reponse = (GeocodeResponse)gson.fromJson((Reader)reader, GeocodeResponse.class);
            }
            finally {
                ((Reader)reader).close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return reponse;
    }

    private static String getURL(GeocoderRequest geocoderRequest) throws UnsupportedEncodingException {
        String address = geocoderRequest.getAddress();
        LatLngBounds bounds = geocoderRequest.getBounds();
        String language = geocoderRequest.getLanguage();
        String region = geocoderRequest.getRegion();
        LatLng location = geocoderRequest.getLocation();
        String urlString = "http://maps.googleapis.com/maps/api/geocode/json?sensor=false";
        if (StringUtils.isNotBlank(address)) {
            urlString = urlString + "&address=" + URLEncoder.encode(address, "UTF-8");
        } else if (location != null) {
            urlString = urlString + "&latlng=" + URLEncoder.encode(location.toUrlValue(), "UTF-8");
        } else {
            throw new IllegalArgumentException("Address or location not defined");
        }
        if (StringUtils.isNotBlank(language)) {
            urlString = urlString + "&language=" + URLEncoder.encode(language, "UTF-8");
        }
        if (StringUtils.isNotBlank(region)) {
            urlString = urlString + "&region=" + URLEncoder.encode(region, "UTF-8");
        }
        if (bounds != null) {
            urlString = urlString + "&bounds=" + URLEncoder.encode(bounds.getSouthwest().toUrlValue() + '|' + bounds.getNortheast().toUrlValue(), "UTF-8");
        }
        return urlString;
    }
}

