/*
 * Decompiled with CFR 0.152.
 */
package fr.ybo.database;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import fr.ybo.database.DataBaseException;
import fr.ybo.database.modele.Base;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DataBaseHelper
extends SQLiteOpenHelper {
    private final Base base;
    private boolean transactionOpen;

    public DataBaseHelper(Context context, List<Class<?>> classes, String dataBaseName, int dataBaseVersion) throws DataBaseException {
        super(context, dataBaseName, null, dataBaseVersion);
        this.base = new Base(classes);
    }

    public void beginTransaction() {
        this.endTransaction();
        this.getWritableDatabase().beginTransaction();
        this.transactionOpen = true;
    }

    public <Entity> void delete(Entity entity) throws DataBaseException {
        this.base.delete(this.getWritableDatabase(), entity);
    }

    public <Entity> void deleteAll(Class<Entity> clazz) throws DataBaseException {
        this.base.deleteAll(this.getWritableDatabase(), clazz);
    }

    public void endTransaction() {
        if (this.transactionOpen && this.getWritableDatabase().inTransaction()) {
            this.getWritableDatabase().setTransactionSuccessful();
            this.getWritableDatabase().endTransaction();
        }
        this.transactionOpen = false;
    }

    public Cursor executeSelectQuery(String query, List<String> selectionArgs) {
        return this.getReadableDatabase().rawQuery(query, selectionArgs == null ? null : selectionArgs.toArray(new String[selectionArgs.size()]));
    }

    public Base getBase() {
        return this.base;
    }

    public <Entity> Entity insert(Entity entity) throws DataBaseException {
        return this.base.insert(this.getWritableDatabase(), entity);
    }

    public void onCreate(SQLiteDatabase db) {
        this.base.createDataBase(db);
    }

    protected abstract Map<Integer, UpgradeDatabase> getUpgrades();

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        try {
            for (int version = oldVersion + 1; version <= newVersion; ++version) {
                if (!this.getUpgrades().containsKey(version)) continue;
                this.getUpgrades().get(version).upgrade(db);
            }
        }
        catch (Exception exception) {
            Cursor cursor = db.query("sqlite_master", Collections.singleton("name").toArray(new String[1]), " type = 'table'", null, null, null, null);
            while (cursor.moveToNext()) {
                String tableName = cursor.getString(0);
                if ("android_metadata".equals(tableName)) continue;
                db.execSQL("DROP TABLE " + tableName);
            }
            cursor.close();
            this.base.createDataBase(db);
        }
    }

    public <Entity> List<Entity> selectAll(Class<Entity> clazz) throws DataBaseException {
        return this.base.selectAll(this.getReadableDatabase(), clazz);
    }

    public <Entity> List<Entity> select(Entity entity) throws DataBaseException {
        return this.base.select(this.getReadableDatabase(), entity, null, null, null);
    }

    public <Entity> List<Entity> select(Entity entity, String orderBy) throws DataBaseException {
        return this.base.select(this.getReadableDatabase(), entity, null, null, orderBy);
    }

    public <Entity> Entity selectSingle(Entity entity) throws DataBaseException {
        List<Entity> entities = this.select(entity);
        if (entities.size() > 1) {
            throw new DataBaseException("Multiple results found for an selectSingle.");
        }
        if (entities.isEmpty()) {
            return null;
        }
        return entities.get(0);
    }

    public <Entity> void update(Entity entity) throws DataBaseException {
        this.base.update(this.getWritableDatabase(), entity);
    }

    protected static interface UpgradeDatabase {
        public void upgrade(SQLiteDatabase var1);
    }
}

