/*
 * Decompiled with CFR 0.152.
 */
package fr.ybo.moteurcsv;

import fr.ybo.moteurcsv.annotation.BaliseCsv;
import fr.ybo.moteurcsv.annotation.FichierCsv;
import fr.ybo.moteurcsv.exception.MoteurCsvException;
import fr.ybo.moteurcsv.modele.ChampCsv;
import fr.ybo.moteurcsv.modele.ClassCsv;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MoteurCsv {
    private final Map<String, ClassCsv> mapFileClasses = new HashMap<String, ClassCsv>(5);
    private String[] enteteCourante;
    private ClassCsv classCourante;

    public MoteurCsv(Iterable<Class<?>> classes) {
        for (Class<?> clazz : classes) {
            this.scannerClass(clazz);
        }
    }

    public Class<?> getClassByFileName(String fileName) {
        return this.mapFileClasses.containsKey(fileName) ? this.mapFileClasses.get(fileName).getClazz() : null;
    }

    private List<String> splitLigne(String ligne, String separateur) {
        ArrayList<String> champs = new ArrayList<String>();
        int indiceDebutChaine = -1;
        boolean enCours = false;
        boolean guillemetEnCours = false;
        boolean guillemetTermine = false;
        for (int indice = 0; indice < ligne.length(); ++indice) {
            if (!enCours) {
                if (ligne.charAt(indice) == separateur.charAt(0)) {
                    champs.add("");
                    guillemetEnCours = false;
                    guillemetTermine = false;
                    indiceDebutChaine = -1;
                    continue;
                }
                if (ligne.charAt(indice) == '\"') {
                    guillemetEnCours = true;
                    continue;
                }
                enCours = true;
                indiceDebutChaine = indice;
                continue;
            }
            if (guillemetEnCours && '\"' == ligne.charAt(indice)) {
                guillemetEnCours = false;
                guillemetTermine = true;
                continue;
            }
            if (ligne.charAt(indice) != separateur.charAt(0)) continue;
            if (indiceDebutChaine == -1) {
                champs.add("");
                continue;
            }
            int indiceFin = indice;
            if (guillemetTermine) {
                indiceFin = indice - 1;
            }
            champs.add(ligne.substring(indiceDebutChaine, indiceFin));
            guillemetEnCours = false;
            guillemetTermine = false;
            enCours = false;
            indiceDebutChaine = -1;
        }
        if (enCours) {
            if (indiceDebutChaine == -1) {
                champs.add("");
            } else {
                int indiceFin = ligne.length();
                if (guillemetTermine) {
                    indiceFin = ligne.length() - 1;
                }
                champs.add(ligne.substring(indiceDebutChaine, indiceFin));
            }
        }
        return champs;
    }

    public Object creerObjet(String ligne) {
        if (this.classCourante == null) {
            throw new MoteurCsvException("La m\u00e9thode creerObjet a \u00e9t\u00e9e appel\u00e9e sans que la m\u00e9thode nouveauFichier n'est \u00e9t\u00e9 appel\u00e9e.");
        }
        try {
            Object objetCsv = this.classCourante.getContructeur().newInstance(null);
            List<String> champs = this.splitLigne(ligne, this.classCourante.getSeparateurWithoutEscape());
            for (int numChamp = 0; numChamp < champs.size(); ++numChamp) {
                String nomChamp;
                ChampCsv champCsv;
                String champ = champs.get(numChamp);
                if (champ == null || "".equals(champ) || (champCsv = this.classCourante.getChampCsv(nomChamp = this.enteteCourante[numChamp])) == null) continue;
                champCsv.getField().setAccessible(true);
                champCsv.getField().set(objetCsv, champCsv.getNewAdapterCsv().parse(champ));
                champCsv.getField().setAccessible(false);
            }
            return objetCsv;
        }
        catch (Exception e) {
            throw new MoteurCsvException("Erreur \u00e0 l'instanciation de la class " + this.classCourante.getClazz().getSimpleName() + " pour la ligne " + ligne, e);
        }
    }

    public void nouveauFichier(String nomFichier, String entete) {
        this.classCourante = this.mapFileClasses.get(nomFichier);
        if (this.classCourante == null) {
            throw new MoteurCsvException("Le fichier " + nomFichier + " n'as pas de classe associ\u00e9e");
        }
        this.enteteCourante = entete.split(this.classCourante.getSeparateur());
        if (Character.isIdentifierIgnorable(this.enteteCourante[0].charAt(0))) {
            this.enteteCourante[0] = this.enteteCourante[0].substring(1);
        }
    }

    public <Objet> List<Objet> parseInputStream(InputStream intputStream, Class<Objet> clazz) {
        ArrayList objets = new ArrayList();
        this.parseFileAndInsert(new BufferedReader(new InputStreamReader(intputStream)), clazz, new InsertInList(objets));
        return objets;
    }

    public <Objet> void parseFileAndInsert(BufferedReader bufReader, Class<Objet> clazz, InsertObject<Objet> insert) {
        try {
            this.nouveauFichier(clazz.getAnnotation(FichierCsv.class).value(), bufReader.readLine());
            String ligne = bufReader.readLine();
            while (ligne != null) {
                insert.insertObject(this.creerObjet(ligne));
                ligne = bufReader.readLine();
            }
        }
        catch (IOException ioException) {
            throw new MoteurCsvException(ioException);
        }
    }

    private void scannerClass(Class<?> clazz) {
        FichierCsv fichierCsv = clazz.getAnnotation(FichierCsv.class);
        if (fichierCsv == null) {
            throw new MoteurCsvException("Annotation FichierCsv non pr\u00e9sente sur la classe " + clazz.getSimpleName());
        }
        if (this.mapFileClasses.get(fichierCsv.value()) != null) {
            return;
        }
        ClassCsv classCsv = new ClassCsv(fichierCsv.separateur(), clazz);
        for (Field field : clazz.getDeclaredFields()) {
            BaliseCsv baliseCsv = field.getAnnotation(BaliseCsv.class);
            if (baliseCsv == null) continue;
            classCsv.setChampCsv(baliseCsv.value(), new ChampCsv(baliseCsv.adapter(), field));
            classCsv.putOrdre(baliseCsv.value(), baliseCsv.ordre());
        }
        this.mapFileClasses.put(fichierCsv.value(), classCsv);
    }

    private void writeEntete(BufferedWriter bufWriter, Iterable<String> nomChamps, ClassCsv classCsv) throws IOException {
        boolean first = true;
        for (String nomChamp : nomChamps) {
            if (!first) {
                bufWriter.write(classCsv.getSeparateurWithoutEscape());
            }
            bufWriter.write(nomChamp);
            first = false;
        }
        bufWriter.write(10);
    }

    private <Objet> void writeLigne(BufferedWriter bufWriter, Iterable<String> nomChamps, ClassCsv classCsv, Objet objet) throws IOException, IllegalAccessException {
        boolean first = true;
        for (String nomChamp : nomChamps) {
            if (!first) {
                bufWriter.write(classCsv.getSeparateurWithoutEscape());
            }
            ChampCsv champCsv = classCsv.getChampCsv(nomChamp);
            champCsv.getField().setAccessible(true);
            Object valeur = champCsv.getField().get(objet);
            champCsv.getField().setAccessible(false);
            if (valeur != null) {
                String champ = champCsv.getNewAdapterCsv().toString(valeur);
                if (champ.contains("\"")) {
                    champ = "\"" + champ + "\"";
                }
                bufWriter.write(champ);
            }
            first = false;
        }
        bufWriter.write(10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <Objet> void writeFile(File file, Iterable<Objet> objets, Class<Objet> clazz) {
        try {
            BufferedWriter bufWriter = new BufferedWriter(new FileWriter(file));
            try {
                final ClassCsv classCsv = this.mapFileClasses.get(clazz.getAnnotation(FichierCsv.class).value());
                ArrayList<String> nomChamps = new ArrayList<String>(10);
                for (String champ : classCsv.getNomChamps()) {
                    nomChamps.add(champ);
                }
                Collections.sort(nomChamps, new Comparator<String>(){

                    @Override
                    public int compare(String o1, String o2) {
                        int anotherVal;
                        int thisVal = classCsv.getOrdre(o1);
                        return thisVal < (anotherVal = classCsv.getOrdre(o2)) ? -1 : (thisVal == anotherVal ? 0 : 1);
                    }
                });
                this.writeEntete(bufWriter, nomChamps, classCsv);
                for (String objet : objets) {
                    this.writeLigne(bufWriter, nomChamps, classCsv, objet);
                }
            }
            finally {
                bufWriter.close();
            }
        }
        catch (Exception exception) {
            throw new MoteurCsvException(exception);
        }
    }

    private static class InsertInList<Objet>
    implements InsertObject<Objet> {
        private List<Objet> objets;

        public InsertInList(List<Objet> objets) {
            this.objets = objets;
        }

        @Override
        public void insertObject(Objet objet) {
            this.objets.add(objet);
        }
    }

    public static interface InsertObject<Objet> {
        public void insertObject(Objet var1);
    }
}

