/*
 * Decompiled with CFR 0.152.
 */
package fr.ybo.database.modele;

import android.content.ContentValues;
import android.database.Cursor;
import fr.ybo.database.DataBaseException;
import fr.ybo.database.annotation.Column;
import fr.ybo.database.annotation.Indexed;
import fr.ybo.database.annotation.PrimaryKey;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Column {
    private final Column.TypeColumn type;
    private final Field field;
    private final String name;
    private final PrimaryKey primaryKey;
    private final Indexed indexed;
    private String tableName;
    private final boolean notNull;

    Column(Column column) {
        this.type = column.type;
        this.field = column.field;
        this.name = column.name;
        this.primaryKey = column.primaryKey;
        this.indexed = column.indexed;
        this.tableName = column.tableName;
        this.notNull = column.notNull;
    }

    Column(Field field, String tableName) {
        this.field = field;
        this.tableName = tableName;
        fr.ybo.database.annotation.Column colonne = field.getAnnotation(fr.ybo.database.annotation.Column.class);
        this.type = colonne.type();
        this.primaryKey = field.getAnnotation(PrimaryKey.class);
        if (this.isAutoIncrement() && !field.getType().equals(Long.class)) {
            throw new DataBaseException("An autoIncrement column is not a Long for the table " + tableName);
        }
        this.name = "".equals(colonne.name()) ? field.getName() : colonne.name();
        this.indexed = field.getAnnotation(Indexed.class);
        this.notNull = colonne.notNull();
    }

    <Entity> void addValue(ContentValues values, Entity entity) {
        Object valeur = this.getValue(entity);
        if (valeur != null) {
            switch (this.type) {
                case BOOLEAN: {
                    values.put(this.name, Integer.valueOf((Boolean)valeur != false ? 1 : 0));
                    break;
                }
                case DATE: {
                    values.put(this.name, Long.valueOf(((Date)valeur).getTime()));
                    break;
                }
                case INTEGER: {
                    values.put(this.name, (Integer)valeur);
                    break;
                }
                case TEXT: {
                    values.put(this.name, (String)valeur);
                    break;
                }
                case NUMERIC: {
                    values.put(this.name, (Double)valeur);
                    break;
                }
                case LIST_TEXT: {
                    List listValeurs = (List)valeur;
                    StringBuilder builder = new StringBuilder();
                    boolean first = true;
                    for (String uneValeur : listValeurs) {
                        if (!first) {
                            builder.append(';');
                        }
                        builder.append(uneValeur);
                        first = false;
                    }
                    values.put(this.name, builder.toString());
                }
            }
        }
    }

    <Entity> void appendWhereIfNotNull(StringBuilder queryBuilder, Entity entity, Collection<String> selectionArgs) {
        String valeur = this.getValueToString(entity);
        if (valeur != null) {
            if (queryBuilder.length() > 0) {
                queryBuilder.append(" AND ");
            }
            queryBuilder.append(this.name);
            queryBuilder.append(" = :");
            queryBuilder.append(this.name);
            selectionArgs.add(valeur);
        }
    }

    String getIndexSqlDef() {
        if (this.indexed == null) {
            return null;
        }
        StringBuilder requete = new StringBuilder("CREATE ");
        if (this.indexed.unique()) {
            requete.append("UNIQUE ");
        }
        requete.append("INDEX ");
        String nameIndex = "".equals(this.indexed.name()) ? this.tableName + '_' + this.name : this.indexed.name();
        requete.append(nameIndex);
        requete.append(" ON ");
        requete.append(this.tableName);
        requete.append(" (");
        requete.append(this.name);
        requete.append(" );");
        return requete.toString();
    }

    String getName() {
        return this.name;
    }

    String getSqlDefinition() {
        StringBuilder requete = new StringBuilder(this.name);
        requete.append(' ');
        requete.append(this.type.getSqlType());
        return requete.toString();
    }

    private Object getValue(Object object) throws DataBaseException {
        try {
            boolean isAccessible = this.field.isAccessible();
            this.field.setAccessible(true);
            Object valeur = this.field.get(object);
            this.field.setAccessible(isAccessible);
            return valeur;
        }
        catch (IllegalArgumentException e) {
            throw new DataBaseException(e);
        }
        catch (IllegalAccessException e) {
            throw new DataBaseException(e);
        }
    }

    <Entity> String getValueToString(Entity entity) throws DataBaseException {
        String retour;
        Object valeur = this.getValue(entity);
        if (valeur == null) {
            return null;
        }
        switch (this.type) {
            case BOOLEAN: {
                retour = (Boolean)valeur != false ? "1" : "0";
                break;
            }
            case DATE: {
                retour = Long.toString(((Date)valeur).getTime());
                break;
            }
            case INTEGER: 
            case NUMERIC: {
                retour = valeur.toString();
                break;
            }
            case TEXT: {
                retour = (String)valeur;
                break;
            }
            case LIST_TEXT: {
                List listValeurs = (List)valeur;
                StringBuilder builder = new StringBuilder();
                boolean first = true;
                for (String uneValeur : listValeurs) {
                    if (!first) {
                        builder.append(';');
                    }
                    builder.append(uneValeur);
                    first = false;
                }
                retour = builder.toString();
                break;
            }
            default: {
                throw new DataBaseException("Column type unknown [" + (Object)((Object)this.type) + ']');
            }
        }
        return retour;
    }

    boolean isIndexed() {
        return this.indexed != null;
    }

    boolean isNotNull() {
        return this.notNull;
    }

    boolean isPrimaryKey() {
        return this.primaryKey != null;
    }

    boolean isAutoIncrement() {
        return this.primaryKey != null && this.primaryKey.autoIncrement();
    }

    <Entity> void completeEntity(Cursor cursor, Entity entity) throws DataBaseException {
        int index = cursor.getColumnIndex(this.name);
        if (!cursor.isNull(index)) {
            Serializable value;
            switch (this.type) {
                case INTEGER: {
                    if (this.field.getType().equals(Long.class)) {
                        value = cursor.getLong(index);
                        break;
                    }
                    value = cursor.getInt(index);
                    break;
                }
                case NUMERIC: {
                    value = cursor.getDouble(index);
                    break;
                }
                case TEXT: {
                    value = cursor.getString(index);
                    break;
                }
                case BOOLEAN: {
                    value = cursor.getInt(index) == 1;
                    break;
                }
                case DATE: {
                    value = new Date(cursor.getLong(index));
                    break;
                }
                case LIST_TEXT: {
                    String valueInCsv = cursor.getString(index);
                    if (valueInCsv == null) {
                        value = null;
                        break;
                    }
                    value = new ArrayList();
                    for (String oneValue : valueInCsv.split(";")) {
                        ((List)((Object)value)).add(oneValue);
                    }
                    break;
                }
                default: {
                    throw new DataBaseException("Column type unknown [" + (Object)((Object)this.type) + ']');
                }
            }
            this.setValue(entity, value);
        }
    }

    void setTableName(String tableName) {
        this.tableName = tableName;
    }

    protected <Entity> void setValue(Entity entity, Object value) throws DataBaseException {
        try {
            boolean isAccessible = this.field.isAccessible();
            this.field.setAccessible(true);
            this.field.set(entity, value);
            this.field.setAccessible(isAccessible);
        }
        catch (IllegalArgumentException e) {
            throw new DataBaseException(e);
        }
        catch (IllegalAccessException e) {
            throw new DataBaseException(e);
        }
    }
}

