/*
 * Decompiled with CFR 0.152.
 */
package fr.ybo.opentripplanner.client.modele;

import fr.ybo.opentripplanner.client.modele.AbsoluteDirection;
import fr.ybo.opentripplanner.client.modele.RelativeDirection;
import java.io.Serializable;

public class WalkStep
implements Serializable {
    private static final long serialVersionUID = 1L;
    public double distance = 0.0;
    public RelativeDirection relativeDirection;
    public String streetName;
    public AbsoluteDirection absoluteDirection;
    public String exit;
    public Boolean stayOn = false;
    public Boolean becomes = false;
    public double lon;
    public double lat;
    public String elevation;

    public void setDirections(double lastAngle, double thisAngle, boolean roundabout) {
        this.relativeDirection = WalkStep.getRelativeDirection(lastAngle, thisAngle, roundabout);
        this.setAbsoluteDirection(thisAngle);
    }

    public String toString() {
        String direction = this.absoluteDirection.toString();
        if (this.relativeDirection != null) {
            direction = this.relativeDirection.toString();
        }
        return "WalkStep(" + direction + " on " + this.streetName + " for " + this.distance + ")";
    }

    public static RelativeDirection getRelativeDirection(double lastAngle, double thisAngle, boolean roundabout) {
        double angleDiff = thisAngle - lastAngle;
        if (angleDiff < 0.0) {
            angleDiff += Math.PI * 2;
        }
        double ccwAngleDiff = Math.PI * 2 - angleDiff;
        if (roundabout) {
            if (angleDiff > ccwAngleDiff) {
                return RelativeDirection.CIRCLE_CLOCKWISE;
            }
            return RelativeDirection.CIRCLE_COUNTERCLOCKWISE;
        }
        if (angleDiff < 0.3 || ccwAngleDiff < 0.3) {
            return RelativeDirection.CONTINUE;
        }
        if (angleDiff < 0.7) {
            return RelativeDirection.SLIGHTLY_RIGHT;
        }
        if (ccwAngleDiff < 0.7) {
            return RelativeDirection.SLIGHTLY_LEFT;
        }
        if (angleDiff < 2.0) {
            return RelativeDirection.RIGHT;
        }
        if (ccwAngleDiff < 2.0) {
            return RelativeDirection.LEFT;
        }
        if (angleDiff < Math.PI) {
            return RelativeDirection.HARD_RIGHT;
        }
        return RelativeDirection.HARD_LEFT;
    }

    public void setAbsoluteDirection(double thisAngle) {
        int octant = (int)(8L + Math.round(thisAngle * 8.0 / (Math.PI * 2))) % 8;
        this.absoluteDirection = AbsoluteDirection.values()[octant];
    }
}

