/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.util;

import com.esotericsoftware.kryo.util.ObjectMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class IdentityMap<K, V> {
    private static final int PRIME1 = -1105259343;
    private static final int PRIME2 = -1262997959;
    private static final int PRIME3 = -825114047;
    public int size;
    K[] keyTable;
    V[] valueTable;
    int capacity;
    int stashSize;
    private float loadFactor;
    private int hashShift;
    private int mask;
    private int threshold;
    private int stashCapacity;
    private int pushIterations;
    private Entries entries;
    private Values values;
    private Keys keys;

    public IdentityMap() {
        this(32, 0.8f);
    }

    public IdentityMap(int n) {
        this(n, 0.8f);
    }

    public IdentityMap(int n, float f) {
        if (n < 0) {
            throw new IllegalArgumentException("initialCapacity must be >= 0: " + n);
        }
        if (this.capacity > 0x40000000) {
            throw new IllegalArgumentException("initialCapacity is too large: " + n);
        }
        this.capacity = ObjectMap.nextPowerOfTwo(n);
        if (f <= 0.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0: " + f);
        }
        this.loadFactor = f;
        this.threshold = (int)((float)this.capacity * f);
        this.mask = this.capacity - 1;
        this.hashShift = 31 - Integer.numberOfTrailingZeros(this.capacity);
        this.stashCapacity = Math.max(3, (int)Math.ceil(Math.log(this.capacity)) * 2);
        this.pushIterations = Math.max(Math.min(this.capacity, 8), (int)Math.sqrt(this.capacity) / 8);
        this.keyTable = new Object[this.capacity + this.stashCapacity];
        this.valueTable = new Object[this.keyTable.length];
    }

    public V put(K k, V v) {
        int n;
        if (k == null) {
            throw new IllegalArgumentException("key cannot be null.");
        }
        K[] KArray = this.keyTable;
        int n2 = System.identityHashCode(k);
        int n3 = n2 & this.mask;
        K k2 = KArray[n3];
        if (k2 == k) {
            V v2 = this.valueTable[n3];
            this.valueTable[n3] = v;
            return v2;
        }
        int n4 = this.hash2(n2);
        K k3 = KArray[n4];
        if (k3 == k) {
            V v3 = this.valueTable[n4];
            this.valueTable[n4] = v;
            return v3;
        }
        int n5 = this.hash3(n2);
        K k4 = KArray[n5];
        if (k4 == k) {
            V v4 = this.valueTable[n5];
            this.valueTable[n5] = v;
            return v4;
        }
        int n6 = n + this.stashSize;
        for (n = this.capacity; n < n6; ++n) {
            if (KArray[n] != k) continue;
            V v5 = this.valueTable[n];
            this.valueTable[n] = v;
            return v5;
        }
        if (k2 == null) {
            KArray[n3] = k;
            this.valueTable[n3] = v;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return null;
        }
        if (k3 == null) {
            KArray[n4] = k;
            this.valueTable[n4] = v;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return null;
        }
        if (k4 == null) {
            KArray[n5] = k;
            this.valueTable[n5] = v;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return null;
        }
        this.push(k, v, n3, k2, n4, k3, n5, k4);
        return null;
    }

    private void putResize(K k, V v) {
        int n = System.identityHashCode(k);
        int n2 = n & this.mask;
        K k2 = this.keyTable[n2];
        if (k2 == null) {
            this.keyTable[n2] = k;
            this.valueTable[n2] = v;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        int n3 = this.hash2(n);
        K k3 = this.keyTable[n3];
        if (k3 == null) {
            this.keyTable[n3] = k;
            this.valueTable[n3] = v;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        int n4 = this.hash3(n);
        K k4 = this.keyTable[n4];
        if (k4 == null) {
            this.keyTable[n4] = k;
            this.valueTable[n4] = v;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        this.push(k, v, n2, k2, n3, k3, n4, k4);
    }

    private void push(K k, V v, int n, K k2, int n2, K k3, int n3, K k4) {
        V v2;
        K k5;
        K[] KArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n4 = this.mask;
        int n5 = 0;
        int n6 = this.pushIterations;
        while (true) {
            switch (ObjectMap.random.nextInt(3)) {
                case 0: {
                    k5 = k2;
                    v2 = VArray[n];
                    KArray[n] = k;
                    VArray[n] = v;
                    break;
                }
                case 1: {
                    k5 = k3;
                    v2 = VArray[n2];
                    KArray[n2] = k;
                    VArray[n2] = v;
                    break;
                }
                default: {
                    k5 = k4;
                    v2 = VArray[n3];
                    KArray[n3] = k;
                    VArray[n3] = v;
                }
            }
            int n7 = System.identityHashCode(k5);
            n = n7 & n4;
            k2 = KArray[n];
            if (k2 == null) {
                KArray[n] = k5;
                VArray[n] = v2;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            n2 = this.hash2(n7);
            k3 = KArray[n2];
            if (k3 == null) {
                KArray[n2] = k5;
                VArray[n2] = v2;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            n3 = this.hash3(n7);
            k4 = KArray[n3];
            if (k4 == null) {
                KArray[n3] = k5;
                VArray[n3] = v2;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            if (++n5 == n6) break;
            k = k5;
            v = v2;
        }
        this.putStash(k5, v2);
    }

    private void putStash(K k, V v) {
        if (this.stashSize == this.stashCapacity) {
            this.resize(this.capacity << 1);
            this.put(k, v);
            return;
        }
        int n = this.capacity + this.stashSize;
        this.keyTable[n] = k;
        this.valueTable[n] = v;
        ++this.stashSize;
        ++this.size;
    }

    public V get(K k) {
        int n = System.identityHashCode(k);
        int n2 = n & this.mask;
        if (k != this.keyTable[n2] && k != this.keyTable[n2 = this.hash2(n)] && k != this.keyTable[n2 = this.hash3(n)]) {
            return this.getStash(k, null);
        }
        return this.valueTable[n2];
    }

    public V get(K k, V v) {
        int n = System.identityHashCode(k);
        int n2 = n & this.mask;
        if (k != this.keyTable[n2] && k != this.keyTable[n2 = this.hash2(n)] && k != this.keyTable[n2 = this.hash3(n)]) {
            return this.getStash(k, v);
        }
        return this.valueTable[n2];
    }

    private V getStash(K k, V v) {
        int n;
        K[] KArray = this.keyTable;
        int n2 = n + this.stashSize;
        for (n = this.capacity; n < n2; ++n) {
            if (KArray[n] != k) continue;
            return this.valueTable[n];
        }
        return v;
    }

    public V remove(K k) {
        int n = System.identityHashCode(k);
        int n2 = n & this.mask;
        if (this.keyTable[n2] == k) {
            this.keyTable[n2] = null;
            V v = this.valueTable[n2];
            this.valueTable[n2] = null;
            --this.size;
            return v;
        }
        n2 = this.hash2(n);
        if (this.keyTable[n2] == k) {
            this.keyTable[n2] = null;
            V v = this.valueTable[n2];
            this.valueTable[n2] = null;
            --this.size;
            return v;
        }
        n2 = this.hash3(n);
        if (this.keyTable[n2] == k) {
            this.keyTable[n2] = null;
            V v = this.valueTable[n2];
            this.valueTable[n2] = null;
            --this.size;
            return v;
        }
        return this.removeStash(k);
    }

    V removeStash(K k) {
        int n;
        K[] KArray = this.keyTable;
        int n2 = n + this.stashSize;
        for (n = this.capacity; n < n2; ++n) {
            if (KArray[n] != k) continue;
            V v = this.valueTable[n];
            this.removeStashIndex(n);
            --this.size;
            return v;
        }
        return null;
    }

    void removeStashIndex(int n) {
        --this.stashSize;
        int n2 = this.capacity + this.stashSize;
        if (n < n2) {
            this.keyTable[n] = this.keyTable[n2];
            this.valueTable[n] = this.valueTable[n2];
            this.valueTable[n2] = null;
        } else {
            this.valueTable[n] = null;
        }
    }

    public void clear() {
        K[] KArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n = this.capacity + this.stashSize;
        while (n-- > 0) {
            KArray[n] = null;
            VArray[n] = null;
        }
        this.size = 0;
        this.stashSize = 0;
    }

    public boolean containsValue(Object object, boolean bl) {
        V[] VArray = this.valueTable;
        if (object == null) {
            K[] KArray = this.keyTable;
            int n = this.capacity + this.stashSize;
            while (n-- > 0) {
                if (KArray[n] == null || VArray[n] != null) continue;
                return true;
            }
        } else if (bl) {
            int n = this.capacity + this.stashSize;
            while (n-- > 0) {
                if (VArray[n] != object) continue;
                return true;
            }
        } else {
            int n = this.capacity + this.stashSize;
            while (n-- > 0) {
                if (!object.equals(VArray[n])) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsKey(K k) {
        int n = System.identityHashCode(k);
        int n2 = n & this.mask;
        if (k != this.keyTable[n2] && k != this.keyTable[n2 = this.hash2(n)] && k != this.keyTable[n2 = this.hash3(n)]) {
            return this.containsKeyStash(k);
        }
        return true;
    }

    private boolean containsKeyStash(K k) {
        int n;
        K[] KArray = this.keyTable;
        int n2 = n + this.stashSize;
        for (n = this.capacity; n < n2; ++n) {
            if (KArray[n] != k) continue;
            return true;
        }
        return false;
    }

    public K findKey(Object object, boolean bl) {
        V[] VArray = this.valueTable;
        if (object == null) {
            K[] KArray = this.keyTable;
            int n = this.capacity + this.stashSize;
            while (n-- > 0) {
                if (KArray[n] == null || VArray[n] != null) continue;
                return KArray[n];
            }
        } else if (bl) {
            int n = this.capacity + this.stashSize;
            while (n-- > 0) {
                if (VArray[n] != object) continue;
                return this.keyTable[n];
            }
        } else {
            int n = this.capacity + this.stashSize;
            while (n-- > 0) {
                if (!object.equals(VArray[n])) continue;
                return this.keyTable[n];
            }
        }
        return null;
    }

    public void ensureCapacity(int n) {
        int n2 = this.size + n;
        if (n2 >= this.threshold) {
            this.resize(ObjectMap.nextPowerOfTwo((int)((float)n2 / this.loadFactor)));
        }
    }

    private void resize(int n) {
        int n2 = this.capacity + this.stashSize;
        this.capacity = n;
        this.threshold = (int)((float)n * this.loadFactor);
        this.mask = n - 1;
        this.hashShift = 31 - Integer.numberOfTrailingZeros(n);
        this.stashCapacity = Math.max(3, (int)Math.ceil(Math.log(n)) * 2);
        this.pushIterations = Math.max(Math.min(n, 8), (int)Math.sqrt(n) / 8);
        K[] KArray = this.keyTable;
        V[] VArray = this.valueTable;
        this.keyTable = new Object[n + this.stashCapacity];
        this.valueTable = new Object[n + this.stashCapacity];
        this.size = 0;
        this.stashSize = 0;
        for (int i = 0; i < n2; ++i) {
            K k = KArray[i];
            if (k == null) continue;
            this.putResize(k, VArray[i]);
        }
    }

    private int hash2(long l) {
        return (int)(((l *= -1262997959L) ^ l >>> this.hashShift) & (long)this.mask);
    }

    private int hash3(long l) {
        return (int)(((l *= -825114047L) ^ l >>> this.hashShift) & (long)this.mask);
    }

    public String toString() {
        K k;
        if (this.size == 0) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append('[');
        K[] KArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n = KArray.length;
        while (n-- > 0) {
            k = KArray[n];
            if (k == null) continue;
            stringBuilder.append(k);
            stringBuilder.append('=');
            stringBuilder.append(VArray[n]);
            break;
        }
        while (n-- > 0) {
            k = KArray[n];
            if (k == null) continue;
            stringBuilder.append(", ");
            stringBuilder.append(k);
            stringBuilder.append('=');
            stringBuilder.append(VArray[n]);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public Entries<K, V> entries() {
        if (this.entries == null) {
            this.entries = new Entries(this);
        } else {
            this.entries.reset();
        }
        return this.entries;
    }

    public Values<V> values() {
        if (this.values == null) {
            this.values = new Values(this);
        } else {
            this.values.reset();
        }
        return this.values;
    }

    public Keys<K> keys() {
        if (this.keys == null) {
            this.keys = new Keys(this);
        } else {
            this.keys.reset();
        }
        return this.keys;
    }

    public static class Keys<K>
    extends MapIterator<K, Object>
    implements Iterable<K>,
    Iterator<K> {
        public Keys(IdentityMap<K, ?> identityMap) {
            super(identityMap);
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public K next() {
            Object k = this.map.keyTable[this.nextIndex];
            this.currentIndex = this.nextIndex;
            this.findNextIndex();
            return k;
        }

        @Override
        public Iterator<K> iterator() {
            return this;
        }

        public ArrayList<K> toArray() {
            ArrayList<K> arrayList = new ArrayList<K>(this.map.size);
            while (this.hasNext) {
                arrayList.add(this.next());
            }
            return arrayList;
        }
    }

    public static class Values<V>
    extends MapIterator<Object, V>
    implements Iterable<V>,
    Iterator<V> {
        public Values(IdentityMap<?, V> identityMap) {
            super(identityMap);
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public V next() {
            Object v = this.map.valueTable[this.nextIndex];
            this.currentIndex = this.nextIndex;
            this.findNextIndex();
            return v;
        }

        @Override
        public Iterator<V> iterator() {
            return this;
        }

        public ArrayList<V> toArray() {
            ArrayList<V> arrayList = new ArrayList<V>(this.map.size);
            while (this.hasNext) {
                arrayList.add(this.next());
            }
            return arrayList;
        }

        public void toArray(ArrayList<V> arrayList) {
            while (this.hasNext) {
                arrayList.add(this.next());
            }
        }
    }

    public static class Entries<K, V>
    extends MapIterator<K, V>
    implements Iterable<Entry<K, V>>,
    Iterator<Entry<K, V>> {
        private Entry<K, V> entry = new Entry();

        public Entries(IdentityMap<K, V> identityMap) {
            super(identityMap);
        }

        @Override
        public Entry<K, V> next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            K[] KArray = this.map.keyTable;
            this.entry.key = KArray[this.nextIndex];
            this.entry.value = this.map.valueTable[this.nextIndex];
            this.currentIndex = this.nextIndex;
            this.findNextIndex();
            return this.entry;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public Iterator<Entry<K, V>> iterator() {
            return this;
        }
    }

    private static class MapIterator<K, V> {
        public boolean hasNext;
        final IdentityMap<K, V> map;
        int nextIndex;
        int currentIndex;

        public MapIterator(IdentityMap<K, V> identityMap) {
            this.map = identityMap;
            this.reset();
        }

        public void reset() {
            this.currentIndex = -1;
            this.nextIndex = -1;
            this.findNextIndex();
        }

        void findNextIndex() {
            this.hasNext = false;
            K[] KArray = this.map.keyTable;
            int n = this.map.capacity + this.map.stashSize;
            while (++this.nextIndex < n) {
                if (KArray[this.nextIndex] == null) continue;
                this.hasNext = true;
                break;
            }
        }

        public void remove() {
            if (this.currentIndex < 0) {
                throw new IllegalStateException("next must be called before remove.");
            }
            if (this.currentIndex >= this.map.capacity) {
                this.map.removeStashIndex(this.currentIndex);
            } else {
                this.map.keyTable[this.currentIndex] = null;
                this.map.valueTable[this.currentIndex] = null;
            }
            this.currentIndex = -1;
            --this.map.size;
        }
    }

    public static class Entry<K, V> {
        public K key;
        public V value;

        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

