/*
 * bandcampDirect
 * Copyright (C) 2019 Fynn Godau
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * Not affiliated with bandcamp, Incorporated.
 */

package godau.fynn.bandcampdirect.model;

import androidx.annotation.Nullable;
import godau.fynn.bandcampdirect.Bandcamp;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.HttpUrl;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

public class User {

    private String identityToken;
    private @Nullable String username;

    public User() {}

    public User(String identityToken) {
        if (identityToken != null) {
            this.identityToken = identityToken;
        }
    }

    public CookieJar makeCookieJar() {
        return new CookieJar() {
            @Override
            public void saveFromResponse(HttpUrl url, List<Cookie> cookies) {

            }

            @Override
            public List<Cookie> loadForRequest(HttpUrl url) {
                ArrayList<Cookie> cookies = new ArrayList<>();

                // Add identity cookie if logged in
                if (identityToken != null && !identityToken.isEmpty()) {
                    Cookie identityCookie = new Cookie.Builder()
                            .domain("bandcamp.com")
                            .name("identity")
                            .value(identityToken)
                            .secure()
                            .path("/")
                            .build();
                    cookies.add(identityCookie);
                }

                return cookies;
            }
        };
    }

    public void update(String html) {
        try {
            JSONObject fanData = Bandcamp.getJSONFromJavaScriptVariables(html, "FanData");

            boolean loggedIn = Bandcamp.getBooleanNullsave(fanData, "logged_in");

            if (loggedIn) {
                username = fanData.getString("name");
            }

        } catch (JSONException | ArrayIndexOutOfBoundsException e) {
            // Just don't do it then

            // (don't spam logcat with stack traces)
        }

    }

    @Nullable
    public String getUsername() {
        return username;
    }

    public String getIdentityCookie() {
        return "identity=" + identityToken;
    }
}
