/*
 * bandcampDirect
 * Copyright (C) 2019 Fynn Godau
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * Not affiliated with bandcamp, Incorporated.
 */

package godau.fynn.bandcampdirect.view;

import android.content.Context;
import android.content.Intent;
import android.view.View;
import android.widget.LinearLayout;
import godau.fynn.bandcampdirect.model.Website;

public class WebsiteRowView extends RowView {

    private Website website;

    public WebsiteRowView(Context context, LinearLayout parentView, Website website) {
        super(context, parentView, website.getTitle(), false, RowView.BROWSER);

        this.website = website;
    }

    @Override
    protected void setOnClickListeners(Context context, View play, View open, int action) {
        open.setOnClickListener(v -> {
            Intent intent = new Intent(Intent.ACTION_VIEW, website.getUri());
            context.startActivity(intent);
        });
    }
}
