/*
 * campfire, formerly known as bandcampDirect
 * Copyright (C) 2020 Fynn Godau
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * Not affiliated with bandcamp, Incorporated.
 */

package godau.fynn.bandcampdirect.adapter;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import androidx.annotation.NonNull;
import godau.fynn.bandcampdirect.R;
import godau.fynn.bandcampdirect.model.CoverSize;
import godau.fynn.bandcampdirect.view.RowView;
import godau.fynn.typedrecyclerview.SimpleRecyclerViewAdapter;
import okhttp3.*;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public abstract class RowAdapter<T> extends SimpleRecyclerViewAdapter<T, RowView> {

    private static final OkHttpClient client = new OkHttpClient();

    public RowAdapter(List<T> content) {
        super(content);
    }

    @NonNull
    @Override
    public RowView onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new RowView(context);
    }

    @Override
    public int getItemCount() {
        return content.size();
    }

    public static void loadImage(RowView rowView, Object associated, String cover) {
        rowView.setAssociatedObject(associated);

        rowView.getCoverView().setImageDrawable(null);

        if (cover == null) return;

        Request request = new Request.Builder()
                .url(CoverSize.X100.getCover(cover))
                .build();

        client.newCall(request).enqueue(new Callback() {
            @Override
            public void onFailure(Call call, IOException e) {
                e.printStackTrace();
            }

            @Override
            public void onResponse(Call call, Response response) {

                if (rowView.getAssociatedObject() != associated) {
                    Log.w("ROWADAPTER", "Did not display image because of associated object mismatch: " +
                            rowView.getAssociatedObject().toString() + " is not " + associated.toString());
                    return;
                }
                ;

                InputStream inputStream = response.body().byteStream();
                Bitmap bitmap = BitmapFactory.decodeStream(inputStream);

                new Handler(Looper.getMainLooper()).post(() -> {
                    rowView.setCoverArt(bitmap);
                    Animation fadeInAnimation = AnimationUtils.loadAnimation(rowView.getCoverView().getContext(), R.anim.fade_in);
                    rowView.getCoverView().startAnimation(fadeInAnimation);
                });

            }
        });
    }
}
