/*
 * campfire, formerly known as bandcampDirect
 * Copyright (C) 2020 Fynn Godau
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * Not affiliated with bandcamp, Incorporated.
 */

package godau.fynn.bandcampdirect.model;

/**
 * @see <a href=ttps://community.metabrainz.org/t/reference-bandcamp-album-art-sizes/214623>Reference: Bandcamp album art sizes</a>
 */
public enum CoverSize {

    /**
     * Original format
     */
    UNLIMITED(0),
    /**
     * Limited to 1200x1200, original aspect ration
     */
    X1200(10),
    /**
     * Limited to 350x350, cropped 1:1
     */
    X350(2),
    /**
     * Limited to 100x100, cropped 1:1
     */
    X100(3),
    /**
     * Limited to 50x50
     */
    X50(42),
    /**
     * Limited to 25x25, cropped 1:1
     */
    X25(22);

    final int id;
    CoverSize(int id) {
        this.id = id;
    }

    public String getCover(String url) {
        if (url == null) return null;
        else return url.split("_")[0] + '_' + id;
    }

}
