/*
 * campfire, formerly known as bandcampDirect
 * Copyright (C) 2020 Fynn Godau
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * Not affiliated with bandcamp, Incorporated.
 */

package godau.fynn.bandcampdirect.model;

import androidx.annotation.StringRes;
import godau.fynn.bandcampdirect.R;

/**
 * Represents content displayed in recycler views.
 */
public abstract class MetadataDisplayable {

    /**
     * Represents a headline
     */
    public static abstract class Header extends MetadataDisplayable {
        public abstract @StringRes int getHeaderText();
    }

    public static class ShowHeader extends MetadataDisplayable.Header {
        @Override
        public int getHeaderText() {
            return R.string.shows;
        }
    }

    public static class SiteHeader extends MetadataDisplayable.Header {
        @Override
        public int getHeaderText() {
            return R.string.sites;
        }
    }

    /**
     * Represents a text with headline
     */
    public static abstract class Text extends MetadataDisplayable.Header {

        private final String content;

        protected Text(String content) {
            this.content = content;
        }

        public String getContentText() {
            return content;
        }
    }

    public static class Info extends MetadataDisplayable.Text {
        public Info(String content) {
            super(content);
        }

        @Override
        public int getHeaderText() {
            return R.string.info;
        }
    }

    public static class Lyrics extends MetadataDisplayable.Text {
        public Lyrics(String content) {
            super(content);
        }

        @Override
        public int getHeaderText() {
            return R.string.lyrics;
        }

        @Override
        public String getContentText() {
            if (super.getContentText() == null) {
                return "Lyrics were not downloaded, please rediscover";
            } else {
                return super.getContentText();
            }
        }
    }
}
