/*
 * campfire, formerly known as bandcampDirect
 * Copyright (C) 2020 Fynn Godau
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * Not affiliated with bandcamp, Incorporated.
 */

package godau.fynn.bandcampdirect.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import godau.fynn.bandcampdirect.R;

import static android.view.View.INVISIBLE;
import static android.view.View.VISIBLE;

public class RowView extends RecyclerView.ViewHolder {

    public enum Action {
        NONE, OPEN, DISCOVER, BROWSER, ARTIST_OPEN
    }

    private final Context context;

    private final TextView title;
    private final TextView paid;
    private final ImageButton button;
    private final RelativeLayout relativeLayout;
    private final ImageView cover;

    private Object associated;


    public RowView(Context context) {
        super(LayoutInflater.from(context).inflate(R.layout.row_list, null));
        this.context = context;

        relativeLayout = itemView.findViewById(R.id.rowLayout);
        title = relativeLayout.findViewById(R.id.title);
        paid = relativeLayout.findViewById(R.id.paid);
        button = relativeLayout.findViewById(R.id.button);
        cover = relativeLayout.findViewById(R.id.cover);
    }

    public void bind(String title, boolean paid, Action action) {
        this.title.setText(title);

        this.paid.setVisibility(paid? VISIBLE : INVISIBLE);

        if (action == Action.NONE)
            button.setVisibility(INVISIBLE);
        else
            button.setVisibility(VISIBLE);

        switch (action) {
            default:
            case OPEN:
            case ARTIST_OPEN:
                button.setImageDrawable(context.getDrawable(R.drawable.ic_right_24dp));
                break;

            case DISCOVER:
                button.setImageDrawable(context.getDrawable(R.drawable.ic_search_24dp));
                break;

            case BROWSER:
                button.setImageDrawable(context.getDrawable(R.drawable.ic_browser_24dp));
                break;
        }
    }

    public void setAssociatedObject(Object o) {
        associated = o;
    }

    public Object getAssociatedObject() {
        return associated;
    }

    public void setOnButtonClickListener(View.OnClickListener onClickListener) {
        button.setOnClickListener(onClickListener);
    }

    public void setOnLongClickListener(View.OnLongClickListener onLongClickListener) {
        if (button.getVisibility() == VISIBLE)
            button.setOnLongClickListener(onLongClickListener);
        else
            relativeLayout.setOnLongClickListener(onLongClickListener);
    }

    public void setOnItemClickListener(View.OnClickListener onClickListener) {
        relativeLayout.setOnClickListener(onClickListener);
    }

    public ImageView getCoverView() {
        return cover;
    }

    public void setCoverArt(Bitmap bitmap) {
        cover.setImageBitmap(bitmap);
    }
}
