# Tanks of Freedom Community Ports Guide

## About this guide

This file is meant to be a guide for any and all ToF community members wanting to export the game on their own. It is not meant to help with game development, but rather focuses on the existing configuration.

## Engine configuration

Engine settings for ToF contain a number of custom parameters, that allow for a limited configuration of funcionalities available in the exported binary.

### Engine built-in settings

There are no special restrictions regarding most of the default engine settings. Some of these are strongly recommended though. For the documentation of these parameter please refer to Godot Engine docs.
Resolution notice: game is not guaranteed to render correctly in resolutions lower than 800x480 and bigger than 1920x1080.

#### audio/use_chorus_reverb
recommended: false

#### audio/stream_volume_scale
recommended: 0.5

#### audio/fx_volume_scale
recommended: 0.2

#### display/stretch_mode
recommended: "disabled"

#### display/stretch_aspect
recommended: "keep"

#### display/width
at least: 800
recommended: 1280
at most: 1920

#### display/height
at least: 480
recommended: 720
at most: 1080

#### display/orientation
recommended: "landscape"

#### image_loader/filter
recommended: false

#### image_loader/gen_mipmaps
recommended: false

#### rasterizer/trilinear_mipmap_filter
recommended: false

#### rasterizer/anisotropic_filter_level
recommended: 1.0

#### rasterizer/use_pixel_snap
recommended: true

#### render/room_cull_enabled
recommended: false

#### render/thread_model
recommended: 2

#### render/mipmap_policy
recommended: 0

#### render/shadows_enabled
recommended: false

#### render/default_clear_color
recommended: #ff005784

#### render/light_discard_enabled
recommended: true


### Custom settings

ToF adds a number of custom settings to the engine configuration. While some of these might be omitted, we strongly suggest not to do so, as the game might become unstable.

#### tof/enable_save_load
Enable game save and resume. Could be turned off for systems with filesystem restrictions.
Values: true/false

#### tof/enable_workshop
Enable of disable in-game map editor. Could be turned off for systems with filesystem restrictions.
Values: true/false

#### tof/map_upload_win
Require a map to be won in skirmish mode before upload is allowed.
Values: true/false

#### tof/online
Enable online funcionalities (map sharing, multiplayer).
Values: true/false

#### tof/resolution_override
Allow to switch between set-resolution windowed mode and native-resolution fullscreen.
IMPORTANT: set this to false for platforms with fixed resolution (i.e. mobile, consoles).
Values: true/false

#### tof/default_zoom (deprecated)
Default zoom value. This setting no longer works.
Values: float

#### tof/selector_offset (deprecated)
Map tiles click detection offset. This setting no longer works.
Values: integer

#### tof/api_location
A url where a ToF server is hosted. This parameter must be set up correctly for online functions to work.
Values: string/URL

#### tof/pandora_input
Enable controls specific for Pandora handheld console
Values: true/false

#### tof/hud_layout
Default HUD layout to be loaded into the game
Values: "default", "overscan", "pandora"

#### tof/hud_allow_overscan
Allow HUD layout to be switched to overscan
Values: true/false

## Export configuration

ToF export settings has very few particular requirements. In most cases, you can use your own settings file.

### Permissions

If the target platform requires permission settings, here is a list of requirements.

#### permissions/internet
recommended: true (required, if online functions are enabled in the engine)

## Stock configurations

ToF repository contains a set of predefined engine and export configurations for a variety of platforms. These configurations can be found in the *buildConfig* folder.
When preparing a new export, please check, if one of the provided files does cover your needs already. For example, default *desktop* settings should be fine for any desktop environment, while *android* settings should be a baseline for any platform with fixed resolution and enforced fullscreen.

Provided export settings are often just defaults generated by the Godot Engine. Android export settings have all of the required permissions already configured. Please note, that android export is only provided as a .dist file, and additional release configuration (versioning, keystore) must be filled in.

## Export scripts

Repository contains a *bin* folder with some bash scripts to help out with game exports. In order to use this, you need:

- bash shell
- godot headless (server) binary available in PATH named as 'linux_server.64' or 'godot_headless'
- export templates installed

### Export usage instructions

All of the commands assume, that you are using bash, and current directory is the project root

#### *./bin/export*

will show you the list of available commands

#### *./bin/export list*

will show you the list of configured target platforms detected

#### *./bin/export bootstrap (target name)*

will bootstap the configuration for (target) from the buildConfig dir, while preserving current ones

*(target name)* - one of the target names from 'list'

#### *./bin/export cleanup*

will attempt to remove bootstrapped configs and restore ones, that were present during bootstrap

#### *./bin/export build (target_name) (destination dir) (base file name)*

will export a target binary

*(target name)* - one of the target names from 'list'

*(destination dir)* - a directory, where binary will be placed, additional subfolder defined in build_(target name).cfg will be created (i.e. tof-build)

*(base file name)* - base for a binary file name, additional suffix defined in build_(target name).cfg will be added (i.e. win64.exe)

#### *./bin/export all (destination dir) (base file name)*

will export all available targets

*(destination dir)* - a directory, where binary will be placed, additional subfolder defined in build_(target name).cfg will be created (i.e. tof-build)

*(base file name)* - base for a binary file name, additional suffix defined in build_(target name).cfg will be added (i.e. win64.exe)



### Android usage instructions

There are two scripts dedicated for work with android devices. Only one android device (with developer mode turned on) must be plugged in via usb cable, and adb binary must be available in the PATH.

#### *./bin/android_debug*

will build default 'android' target, and upload it to the device

#### *./bin/android_debug logcat*

same as above, but will start a logcat (log printing) as well

#### *./bin/android_logcat*

will connect to the android device and start logcat


