# Tanks of Freedom

![Tanks of Freedom](https://i.imgur.com/Xa66BXO.png)

## Indie Turn Based Strategy in Isometric Pixel Art

Classic turn-based strategy game with two armies fighting against each other. Challenge yourself in campaign against AI or hot-seat battle with a friend. Using easy map editor you can create any imaginable scenario to play and share online for others to discover!

![32 colour](https://i.imgur.com/Oe6y4SO.jpg)

Each 32x32 sprite was handcrafted in gorgeous, 32 colour pixel art. Original soundtrack was made on Access Virus C and Korg Electribe. Sound effects were made on real GameBoy hardware. Game is open-source and runs smoothly thanks to Godot Engine.

## Gamepad Controlls
Please note, that all controlls are described for XBox 360 controller. If you are using a different gamepad, please check for coresponding buttons.

### Menus
- DPad to navigate menu buttons
- A to press button
- usual B to back does not work in menus

### In game
- left analog stick to move selector
- A to select units/buildings, move, attack, claim buildings
- B to toggle between game and Menu
- X to buy unit from active building
- Y to end turn
- RB to select next unit with AP

### Workshop
- DPad to navigate buttons
- A to press button
- B to toggle between Workshop and Main Menu
- left analog stick to move selector
- X to place a tile under selector
- Y to erase a tile under selector

Please note, that changing map name with gamepad is not possible at this time. Keyboard is still required.

## Download
### Official builds:
- Windows
- Linux
- OSX
- Android (works on Blackberry, OUYA support currently not working)

### Official pages:
- Available at game page: [w84death.itch.io/tanks-of-freedom](http://w84death.itch.io/tanks-of-freedom)
- Official game page: [tof.p1x.in](http://tof.p1x.in)
- Official P1X page: [p1x.in](http://p1x.in)

### Unofficial ports:
- [F-Droid](https://f-droid.org/repository/browse/?fdid=in.p1x.tanks_of_freedom) thanks to [est31](https://github.com/est31)!
- [FreeBSD](http://www.freshports.org/games/tanks-of-freedom/) thanks to [AMDmi3](https://github.com/AMDmi3)
- [Mageia](http://madb.mageia.org/package/show/application/0/name/tanks-of-freedom) thanks to [Akien](https://github.com/akien-mga)
- [Pandora](https://repo.openpandora.org/?page=detail&app=tanksoffreedom) thanks to Canseco


### Build from sources
To get the latest version of the game you'll need to use the source code and Godot Engine

- download & install [Godot Engine](https://godotengine.org/download)
- download our sources
  - download [master.zip](https://github.com/w84death/Tanks-of-Freedom/archive/master.zip) and unzip
  - or clone the repository using git
- open Godot and import our game
- run :)

Follow [this tutorial](http://docs.godotengine.org/en/latest/tutorials/asset_pipeline/exporting_projects.html) to learn how to export the game for each platform.

## Server

For online funcionalities ToF server is required. Sources can be found in a separate repository [https://github.com/P1X-in/Tanks-of-Freedom-Server](https://github.com/P1X-in/Tanks-of-Freedom-Server)

## Media
![Imgur](http://tof.p1x.in/assets/screen1.jpg)
![Imgur](http://tof.p1x.in/assets/screen2.jpg)

## Credits

![Alt text](http://i.imgur.com/wZPAs75.jpg)

### P1X Team
###  code
   - w84death http://krzysztofjankowski.com
   - czlowiekimadlo https://twitter.com/czlowiekimadlo
   - WrmZ https://plus.google.com/u/0/113866605142376544736/posts

### gfx
   - w84death http://krzysztofjankowski.com licensed under MIT
   - Free font Courier Prime http://www.quoteunquoteapps.com/courierprime/ licensed under OFL

### music
   - QmYaan (Grand Beats) http://www.grandbeats.com/ licensed under CC BY-SA 4.0
   - Mathias Nova http://mathiasnova.blogspot.com/ (older versions only)

### sfx
   - QmYaan (Grand Beats) http://www.grandbeats.com/

### engine
   - Godot Engine https://godotengine.org/

### translations
  - French - [Poussinou](https://github.com/Poussinou)
  - German - [cyberbeat](https://github.com/cyberbeat)
  - English - P1X
  - Polish - P1X

## Public game catalogs

- itch.io [http://w84death.itch.io/tanks-of-freedom](http://w84death.itch.io/tanks-of-freedom)
- Linux Games DB [http://www.lgdb.org/game/tanks-of-freedom](www.lgdb.org/game/tanks-of-freedom)
- Indie DB [http://www.indiedb.com/games/tanks-of-freedom](http://www.indiedb.com/games/tanks-of-freedom)

<a href="http://www.indiedb.com/games/tanks-of-freedom" title="View Tanks of Freedom on Indie DB" target="_blank"><img src="http://button.indiedb.com/popularity/medium/games/39024.png" alt="Tanks of Freedom" /></a>

## The MIT License (MIT)
This license applies both to the code, and to all graphical assets within this repository.

Copyright (c) 2015 P1X

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

## Free font Courier Prime
A Free font Courier Prime used in this project can be found here:
http://www.quoteunquoteapps.com/courierprime/
This font is licensed under OFL license.

## Music & SFX License
Original copyrights of all audio assets belong to QmYaan (Grand Beats) http://www.grandbeats.com/

All sfx and music assets in this repository are licensed under Creative Commons Attribution-ShareAlike 4.0 license (CC BY-SA 4.0).

[Full text of the license provided by Creative Commons](http://creativecommons.org/licenses/by-sa/4.0/legalcode)
