/*************************************************************************/
/*  ray_cast_2d.h                                                        */
/*************************************************************************/
/*                       This file is part of:                           */
/*                           GODOT ENGINE                                */
/*                    http://www.godotengine.org                         */
/*************************************************************************/
/* Copyright (c) 2007-2017 Juan Linietsky, Ariel Manzur.                 */
/*                                                                       */
/* Permission is hereby granted, free of charge, to any person obtaining */
/* a copy of this software and associated documentation files (the       */
/* "Software"), to deal in the Software without restriction, including   */
/* without limitation the rights to use, copy, modify, merge, publish,   */
/* distribute, sublicense, and/or sell copies of the Software, and to    */
/* permit persons to whom the Software is furnished to do so, subject to */
/* the following conditions:                                             */
/*                                                                       */
/* The above copyright notice and this permission notice shall be        */
/* included in all copies or substantial portions of the Software.       */
/*                                                                       */
/* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,       */
/* EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF    */
/* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.*/
/* IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY  */
/* CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,  */
/* TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE     */
/* SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.                */
/*************************************************************************/
#ifndef RAY_CAST_2D_H
#define RAY_CAST_2D_H

#include "scene/2d/node_2d.h"

class RayCast2D : public Node2D {

	OBJ_TYPE(RayCast2D,Node2D);


	bool enabled;
	bool collided;
	ObjectID against;
	int against_shape;
	Vector2 collision_point;
	Vector2 collision_normal;
	Set<RID> exclude;
	uint32_t layer_mask;
	uint32_t type_mask;


	Vector2 cast_to;
protected:

	void _notification(int p_what);
	void _update_raycast_state();
	static void _bind_methods();
public:

	void set_enabled(bool p_enabled);
	bool is_enabled() const;

	void set_cast_to(const Vector2& p_point);
	Vector2 get_cast_to() const;

	void set_layer_mask(uint32_t p_mask);
	uint32_t get_layer_mask() const;

	void set_type_mask(uint32_t p_mask);
	uint32_t get_type_mask() const;

	void force_raycast_update();

	bool is_colliding() const;
	Object *get_collider() const;
	int get_collider_shape() const;
	Vector2 get_collision_point() const;
	Vector2 get_collision_normal() const;

	void add_exception_rid(const RID& p_rid);
	void add_exception(const Object* p_object);
	void remove_exception_rid(const RID& p_rid);
	void remove_exception(const Object* p_object);
	void clear_exceptions();

	RayCast2D();
};

#endif // RAY_CAST_2D_H
