/*
 * Decompiled with CFR 0.152.
 */
package uk.me.jstott.sun;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Calendar;
import java.util.TimeZone;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import uk.me.jstott.coordconv.LatitudeLongitude;
import uk.me.jstott.sun.Sun;
import uk.me.jstott.sun.Time;
import uk.me.jstott.util.JulianDateConverter;

public class SunTimesPanel
extends JPanel {
    private static final long serialVersionUID = -6875061905078672943L;
    private JTextField northingDegrees = new JTextField("51");
    private JTextField northingMinutes = new JTextField("16");
    private JTextField northingSeconds = new JTextField("48");
    private JTextField eastingDegrees = new JTextField("1");
    private JTextField eastingMinutes = new JTextField("4");
    private JTextField eastingSeconds = new JTextField("48");
    private JLabel northingLabel = new JLabel("Northing");
    private JLabel eastingLabel = new JLabel("Easting");
    private JLabel northingDegreesLabel = new JLabel("\u221e");
    private JLabel northingMinutesLabel = new JLabel("'");
    private JLabel northingSecondsLabel = new JLabel("\"");
    private JLabel eastingDegreesLabel = new JLabel("\u221e");
    private JLabel eastingMinutesLabel = new JLabel("'");
    private JLabel eastingSecondsLabel = new JLabel("\"");
    private JLabel dateLabel = new JLabel("Date");
    private Calendar date = Calendar.getInstance();
    private JTextField dateDay = new JTextField(Integer.toString(this.date.get(5)));
    private JComboBox dateMonth = new JComboBox<String>(new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"});
    private JTextField dateYear = new JTextField(Integer.toString(this.date.get(1)));
    private JLabel timeZoneLabel = new JLabel("Time Zone");
    private JComboBox timeZones;
    private JCheckBox daylightSavingsTime = new JCheckBox("Daylight Savings Time", true);
    private JButton goButton = new JButton("Go");
    private JTextField morningAstroTwilight = new JTextField(10);
    private JTextField morningNauticalTwilight = new JTextField(10);
    private JTextField morningCivilTwilight = new JTextField(10);
    private JTextField sunrise = new JTextField(10);
    private JTextField sunset = new JTextField(10);
    private JTextField eveningCivilTwilight = new JTextField(10);
    private JTextField eveningNauticalTwilight = new JTextField(10);
    private JTextField eveningAstroTwilight = new JTextField(10);
    private JLabel morningAstoTwilightLabel = new JLabel("Morning Astronomical Twilight");
    private JLabel morningNauticalTwilightLabel = new JLabel("Morning Nautical Twilight");
    private JLabel morningCivilTwilightLabel = new JLabel("Morning Civil Twilight");
    private JLabel sunriseLabel = new JLabel("Sunrise");
    private JLabel sunsetLabel = new JLabel("Sunset");
    private JLabel eveningCivilTwilightLabel = new JLabel("Evening Civil Twilight");
    private JLabel eveningNauticalTwilightLabel = new JLabel("Evening Nautical Twilight");
    private JLabel eveningAstoTwilightLabel = new JLabel("Evening Astronomical Twilight");

    public SunTimesPanel() {
        super(new BorderLayout());
        JPanel inputPanel = new JPanel(new GridLayout(5, 2));
        inputPanel.add(this.northingLabel);
        JPanel northingPanel = new JPanel(new GridLayout(1, 6));
        northingPanel.add(this.northingDegrees);
        northingPanel.add(this.northingDegreesLabel);
        northingPanel.add(this.northingMinutes);
        northingPanel.add(this.northingMinutesLabel);
        northingPanel.add(this.northingSeconds);
        northingPanel.add(this.northingSecondsLabel);
        inputPanel.add(northingPanel);
        inputPanel.add(this.eastingLabel);
        JPanel eastingPanel = new JPanel(new GridLayout(1, 6));
        eastingPanel.add(this.eastingDegrees);
        eastingPanel.add(this.eastingDegreesLabel);
        eastingPanel.add(this.eastingMinutes);
        eastingPanel.add(this.eastingMinutesLabel);
        eastingPanel.add(this.eastingSeconds);
        eastingPanel.add(this.eastingSecondsLabel);
        inputPanel.add(eastingPanel);
        inputPanel.add(this.dateLabel);
        JPanel datePanel = new JPanel(new GridLayout(1, 3));
        datePanel.add(this.dateDay);
        this.dateMonth.setSelectedIndex(this.date.get(2));
        datePanel.add(this.dateMonth);
        datePanel.add(this.dateYear);
        inputPanel.add(datePanel);
        inputPanel.add(this.timeZoneLabel);
        Object[] timeZoneList = TimeZone.getAvailableIDs();
        Arrays.sort(timeZoneList);
        this.timeZones = new JComboBox<Object>(timeZoneList);
        inputPanel.add(this.timeZones);
        inputPanel.add(new JPanel());
        inputPanel.add(this.daylightSavingsTime);
        JPanel outputPanel = new JPanel(new GridLayout(8, 2));
        outputPanel.add(this.morningAstoTwilightLabel);
        outputPanel.add(this.morningAstroTwilight);
        outputPanel.add(this.morningNauticalTwilightLabel);
        outputPanel.add(this.morningNauticalTwilight);
        outputPanel.add(this.morningCivilTwilightLabel);
        outputPanel.add(this.morningCivilTwilight);
        outputPanel.add(this.sunriseLabel);
        outputPanel.add(this.sunrise);
        outputPanel.add(this.sunsetLabel);
        outputPanel.add(this.sunset);
        outputPanel.add(this.eveningCivilTwilightLabel);
        outputPanel.add(this.eveningCivilTwilight);
        outputPanel.add(this.eveningNauticalTwilightLabel);
        outputPanel.add(this.eveningNauticalTwilight);
        outputPanel.add(this.eveningAstoTwilightLabel);
        outputPanel.add(this.eveningAstroTwilight);
        this.add((Component)inputPanel, "North");
        this.add((Component)this.goButton, "South");
        this.add((Component)outputPanel, "Center");
        this.goButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int nDay = Integer.parseInt(SunTimesPanel.this.dateDay.getText());
                int nMonth = SunTimesPanel.this.dateMonth.getSelectedIndex();
                int nYear = Integer.parseInt(SunTimesPanel.this.dateYear.getText());
                Calendar cal = Calendar.getInstance();
                cal.set(5, nDay);
                cal.set(2, nMonth);
                cal.set(1, nYear);
                double jd = JulianDateConverter.dateToJulian(cal);
                int nDeg = Integer.parseInt(SunTimesPanel.this.northingDegrees.getText());
                int nMin = Integer.parseInt(SunTimesPanel.this.northingMinutes.getText());
                int nSec = Integer.parseInt(SunTimesPanel.this.northingSeconds.getText());
                int eDeg = Integer.parseInt(SunTimesPanel.this.eastingDegrees.getText());
                int eMin = Integer.parseInt(SunTimesPanel.this.eastingMinutes.getText());
                int eSec = Integer.parseInt(SunTimesPanel.this.eastingSeconds.getText());
                LatitudeLongitude ll = new LatitudeLongitude(nDeg, nMin, nSec, eDeg, eMin, eSec);
                TimeZone timeZone = TimeZone.getTimeZone((String)SunTimesPanel.this.timeZones.getSelectedItem());
                boolean dst = SunTimesPanel.this.daylightSavingsTime.isSelected();
                Time mornATTime = Sun.morningAstronomicalTwilightTime(jd, ll, timeZone, dst);
                Time mornNTTime = Sun.morningNauticalTwilightTime(jd, ll, timeZone, dst);
                Time mornCTTime = Sun.morningCivilTwilightTime(jd, ll, timeZone, dst);
                Time sunriseTime = Sun.sunriseTime(jd, ll, timeZone, dst);
                Time sunsetTime = Sun.sunsetTime(jd, ll, timeZone, dst);
                Time evenCTTime = Sun.eveningCivilTwilightTime(jd, ll, timeZone, dst);
                Time evenNTTime = Sun.eveningNauticalTwilightTime(jd, ll, timeZone, dst);
                Time evenATTime = Sun.eveningAstronomicalTwilightTime(jd, ll, timeZone, dst);
                SunTimesPanel.this.morningAstroTwilight.setText(mornATTime.toString());
                SunTimesPanel.this.morningNauticalTwilight.setText(mornNTTime.toString());
                SunTimesPanel.this.morningCivilTwilight.setText(mornCTTime.toString());
                SunTimesPanel.this.sunrise.setText(sunriseTime.toString());
                SunTimesPanel.this.sunset.setText(sunsetTime.toString());
                SunTimesPanel.this.eveningAstroTwilight.setText(evenATTime.toString());
                SunTimesPanel.this.eveningNauticalTwilight.setText(evenNTTime.toString());
                SunTimesPanel.this.eveningCivilTwilight.setText(evenCTTime.toString());
            }
        });
    }
}

