//=========================================================================
//
//  Part of units package -- a Java version of GNU Units program.
//
//  Units is a program for unit conversion originally written in C
//  by Adrian Mariano (adrian@cam.cornell.edu.).
//  Copyright (C) 1996, 1997, 1999, 2000, 2001, 2002, 2003, 2004,
//  2005, 2006, 2007 by Free Software Foundation, Inc.
//
//  Java version Copyright (C) 2003, 2004, 2005, 2006, 2007, 2008,
//  2009 by Roman R Redziejowski (roman.redz@tele2.se).
//
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program. If not, see <http://www.gnu.org/licenses/>.
//
//-------------------------------------------------------------------------
//
//  Change log
//
//    050203 Created for version 1.84.J05.
//    050315 Version 1.84.J07. Changed package name to "units".
//    061229 Version 1.86.J01. New setting of options.
//    070103 Use 'Env.showAbout' to show initial message.
//    091024 Version 1.87.J01. Added serialVersionUID.
//           Used generics for 'Env.filenames'.
//    091103 Implemented personal units file.
//
//=========================================================================

package units;

import java.util.Vector;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;


//HHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHH
//
//  class UnitsWindow
//
//HHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHH
/**
 *  Window for interactive invocation of Units..
 */

class UnitsWindow extends JFrame
implements WindowListener
{
  //=====================================================================
  //  Constructor.
  //=====================================================================
  UnitsWindow()
    {
      Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
      int width = size.width/2;
      int height = size.height/2;
      setSize(width,height);
      setLocation(width/2,height/2);
      setContentPane(new GUI(getRootPane()));
      setTitle("Units " + Env.VERSION);
      setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
      addWindowListener(this);
      setResizable(true);
      setVisible(true);
      validate();       // Make sure GUI is drawn before next step.

      //---------------------------------------------------------------
      //  Build tables.
      //  It must be done after initialization of GUI because it writes
      //  output to GUI's text area (via GUI's writer 'myOut').
      //---------------------------------------------------------------
      Env.getProperties(); // May get file names and locale
      Tables.build();

      //---------------------------------------------------------------
      //  Show initial message.
      //---------------------------------------------------------------
      Env.showAbout();
      Env.gui.outArea.select(0,0);
    }


  //=====================================================================
  //  Initialize window
  //=====================================================================
  static void init()
    {
      //---------------------------------------------------------------
      //  Set up options.
      //  (Locale and filenames may be later changed
      //  by Env.getProperties() invoked from the constructor.)
      //---------------------------------------------------------------
      Env.filenames = new Vector<String>(); // Standard units file
      Env.getPersonalUnits();
      Env.filenames.add(Env.UNITSFILE);

      Env.locale=Env.DEFAULTLOCALE;     // Default locale
      Env.verbose = 2;                  // Verbose output
      Env.quiet = false;                // Don't suppress statistics
      Env.oneline = false;              // Show both output lines
      Env.strict = false;               // Allow reciprocal conversion

      //---------------------------------------------------------------
      //  Set up file access and initialize Browser.
      //---------------------------------------------------------------
      Env.files = new File.StandAcc();  // File access
      Browser.init();

      //---------------------------------------------------------------
      //  Start GUI.
      //---------------------------------------------------------------
      SwingUtilities.invokeLater(new Runnable()
        {  public void run() { new UnitsWindow(); } });
    }


  //=====================================================================
  //
  //  windowListener interface
  //  Needed because Java 1.2.2 does not have option EXIT_ON_CLOSE.
  //
  //=====================================================================
  /**
   *  Captures request to close the window and terminates Units.
   */
  public void windowOpened(WindowEvent e){}
  public void windowClosed(WindowEvent e){}
  public void windowActivated(WindowEvent e){}
  public void windowDeactivated(WindowEvent e){}
  public void windowDeiconified(WindowEvent e){}
  public void windowIconified(WindowEvent e){}
  public void windowClosing(WindowEvent e) { System.exit(0); }


  //=====================================================================
  //  Serial version UID. Unused - defined to eliminate compiler warning
  //=====================================================================
  static final long serialVersionUID = 4711L;
}


