//=========================================================================
//
//  Part of units package -- a Java version of GNU Units program.
//
//  Units is a program for unit conversion originally written in C
//  by Adrian Mariano (adrian@cam.cornell.edu.).
//  Copyright (C) 1996, 1997, 1999, 2000, 2001, 2002, 2003, 2004,
//  2005, 2006, 2007 by Free Software Foundation, Inc.
//
//  Java version Copyright (C) 2003, 2004, 2005, 2006, 2007, 2008,
//  2009 by Roman R Redziejowski (roman.redz@tele2.se).
//
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program. If not, see <http://www.gnu.org/licenses/>.
//
//-------------------------------------------------------------------------
//
//  Change log
//
//    050203 Version 1.84.J05. Total rewrite using common GUI object
//           and common data in Env object.
//    050315 Version 1.84.J07. Changed package name to "units".
//    061229 Version 1.86.J01. New setting of options.
//    070103 Use 'Env.showAbout' to show initial message.
//    091024 Version 1.87.J01. Added serialVersionUID.
//           Used generics for 'Env.filenames'.
//
//=========================================================================

package units;

import java.util.Vector;
import javax.swing.*;



//HHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHH
//
//  The Applet.
//
//HHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHH


public class applet extends JApplet
{
  //=====================================================================
  //  Milestone method: init
  //=====================================================================
  public void init()
    {
      //---------------------------------------------------------------
      //  Set up options.
      //---------------------------------------------------------------
      Env.locale = getParameter("LOCALE");  // Locale from parameter
      if (Env.locale==null)                 // Default if none
        Env.locale=Env.DEFAULTLOCALE;
      Env.filenames = new Vector<String>(); // Standard units file
      Env.filenames.add(Env.UNITSFILE);

      Env.verbose = 2;                      // Verbose output
      Env.quiet = false;                    // Don't suppress statistics
      Env.oneline = false;                  // Show both output lines
      Env.strict = false;                   // Allow reciprocal conversion

      //---------------------------------------------------------------
      //  Set up file access and initialize Browser.
      //---------------------------------------------------------------
      Env.files = new File.AppletAcc();     // File access
      Browser.init();

      //---------------------------------------------------------------
      //  Start GUI.
      //---------------------------------------------------------------
      SwingUtilities.invokeLater(new Runnable()
        {  public void run() { createGUI(); } });

    }


  //=====================================================================
  //  Milestone method: destroy
  //=====================================================================
  public void destroy()
    {
      Tables.clean();
      Browser.close();
      System.exit(0);
    }


  //=====================================================================
  //  Create GUI
  //=====================================================================
  private void createGUI()
    {
      //---------------------------------------------------------------
      //  Initialize GUI.
      //---------------------------------------------------------------
      setSize(getSize());
      setContentPane(new GUI(getRootPane()));
      setVisible(true);
      validate();       // Make sure GUI is drawn before next step.

      //---------------------------------------------------------------
      //  Build tables.
      //  It must be done after initialization of GUI because it writes
      //  output to GUI's text area (via GUI's writer 'myOut').
      //---------------------------------------------------------------
      Tables.build();

      //---------------------------------------------------------------
      //  Show initial message.
      //---------------------------------------------------------------
      Env.showAbout();
      Env.gui.outArea.select(0,0);
    }



  //=====================================================================
  //  Serial version UID. Unused - defined to eliminate compiler warning
  //=====================================================================
  static final long serialVersionUID = 4711L;
}


