package info.toyonos.hfr4droid.core.data;

import info.toyonos.hfr4droid.core.bean.Category;
import info.toyonos.hfr4droid.core.bean.Post;
import info.toyonos.hfr4droid.core.bean.SubCategory;
import info.toyonos.hfr4droid.core.bean.Topic;
import info.toyonos.hfr4droid.core.bean.Topic.TopicType;

import java.util.List;

/**
 * <p>Interface dfinissant le moyen de rcuprer des donnes sur un forum 
 * de discussion MesDiscussions.net</p>
 * 
 * @author ToYonos
 * @see info.toyonos.core.bean.Category
 * @see info.toyonos.core.bean.Topic
 * @see info.toyonos.core.bean.Post
 *  
 */
public interface MDDataRetriever
{
	/**
	 * Rcupre le hash check courant
	 * @return Le hash check dans une <code>String</code>
	 * @throws DataRetrieverException Si un problme survient
	 */
	public String getHashCheck() throws DataRetrieverException;
	
	/**
	 * Rcupre l'url de base du forum
	 * @return L'url de base du forum sous forme de <code>String</code>
	 */
	public String getBaseUrl();

	/**
	 * Rcupre les catgories
	 * @return Une <code>List</code> de <code>Category</code>
	 * @throws DataRetrieverException Si un problme survient
	 */
	public List<Category> getCats() throws DataRetrieverException;
	
	/**
	 * Rcupre une <code>Category</code> par son code
	 * @param code Le code de la catgorie
	 * @return La <code>Category</code> trouve ou null si elle n'existe pas
	 * @throws DataRetrieverException Si un problme survient
	 */
	public Category getCatByCode(String code) throws DataRetrieverException;
	
	/**
	 * Rcupre une <code>Category</code> par son id
	 * @param id L'id de la catgorie
	 * @return La <code>Category</code> trouve ou null si elle n'existe pas
	 * @throws DataRetrieverException Si un problme survient
	 */
	public Category getCatById(long id) throws DataRetrieverException;
	
	/**
	 * Rcupre les sous catgories d'une catgorie
	 * @param cat La <code>Category</code> dsire
	 * @return Une <code>List</code> de <code>SubCategory</code>
	 * @throws DataRetrieverException Si un problme survient
	 */
	public List<SubCategory> getSubCats(Category cat) throws DataRetrieverException;
	
	/**
	 * Indique si les <code>SubCategory</code> d'une catgorie donne sont chargs
	 * @param cat La catgorie cible
	 * @return true les sous catgories sont charges, false sinon
	 */
	public boolean isSubCatsLoaded(Category cat) throws DataRetrieverException;
	
	/**
	 * Rcupre une <code>SubCategory</code> par son id
	 * @param cat La catgorie cible
	 * @param id L'id de la sous-catgorie
	 * @return La <code>SubCategory</code> trouve ou null si elle n'existe pas
	 * @throws DataRetrieverException Si un problme survient
	 */
	public SubCategory getSubCatById(Category cat, long id) throws DataRetrieverException;
	
	/**
	 * Rcupre les topics d'un type donn d'une catgorie
	 * @param cat La <code>Category</code> dsire
	 * @param type Le type de topic (tous, drapeaux cyan, drapeau rouges ou favoris)
	 * @return Une <code>List</code> de <code>Topic</code>
	 * @throws DataRetrieverException Si un problme survient
	 * @see #getTopics(Category, TopicType, int)
	 */
	public List<Topic> getTopics(Category cat, TopicType type) throws DataRetrieverException;

	/**
	 * Rcupre les topics d'un type donn et de la page donne d'une catgorie
	 * @param cat La <code>Category</code> dsire
	 * @param type Le type de topic (tous, drapeaux cyan, drapeau rouges ou favoris) 
	 * @param pageNumber Le numro de la page
	 * @return Une <code>List</code> de <code>Topic</code>
	 * @throws DataRetrieverException Si un problme survient
	 */
	public List<Topic> getTopics(Category cat, TopicType type, int pageNumber) throws DataRetrieverException;

	/**
	 * Rcupre les posts de la page donne d'un topic
	 * @param topic Le <code>Topic</code> dsir
	 * @param pageNumber Le numro de la page
	 * @return Une <code>List</code> de <code>Post</code>
	 * @throws DataRetrieverException Si un problme survient
	 */
	public List<Post> getPosts(Topic topic, int pageNumber) throws DataRetrieverException;

	/**
	 * Donne le nombre de nouveaux mps
	 * @param topic Rfrence d'un topic. Si un seul nouveau mp existe, il sera renvoy par ce biais
	 * @return Le nombre de nouveaux mps
	 * @throws DataRetrieverException Si un problme survient
	 */
	public int countNewMps(Topic topic) throws DataRetrieverException;

	/**
	 * Rcupre les smileys  insrer dans un post 
	 * @param tag Le tag des smileys recherchs
	 * @return Le code HTML des smileys trouvs
	 * @throws DataRetrieverException Si un problme survient
	 */
	public String getSmiliesByTag(String tag) throws DataRetrieverException;

	/**
	 * Rcupre le BBCode d'un post  quoter 
	 * @param post Le post concern
	 * @return Le BBCode obtenu
	 * @throws DataRetrieverException Si un problme survient
	 */
	public String getQuote(Post post) throws DataRetrieverException;

	/**
	 * Rcupre le BBCode d'un post  diter 
	 * @param post Le post concern
	 * @return Le BBCode obtenu
	 * @throws DataRetrieverException Si un problme survient
	 */
	public String getPostContent(Post post) throws DataRetrieverException;
	
	/**
	 * Rcupre les mots cls d'un smiley
	 * @param code le code du smiley
	 * @return Les mots cls obtenus
	 * @throws DataRetrieverException Si un problme survient
	 */
	public String getKeywords(String code) throws DataRetrieverException;
}