package info.toyonos.hfr4droid.service;

import info.toyonos.hfr4droid.HFR4droidApplication;
import info.toyonos.hfr4droid.activity.HFR4droidActivity;
import info.toyonos.hfr4droid.core.bean.Topic;
import info.toyonos.hfr4droid.core.data.DataRetrieverException;
import info.toyonos.hfr4droid.core.data.MDDataRetriever;
import android.content.Intent;
import android.util.Log;

/**
 * <p>Service qui va vrifier et notifier les nouveaux mps  l'utilisateur.</p>
 * <p>Si au moins un nouveau mp est dtect, une notification est envoye au systme.</p>
 * 
 * @author ToYonos
 * @see android.app.Service
 *
 */
public class MpCheckService extends MpNotifyService
{
	@Override
	protected Runnable doService(Intent intent)
	{
		return new Runnable()
		{
			public void run()
			{
				checkNewMps(getNotificationType());
				stopSelf();
			}
		};
	}

	protected void checkNewMps(NotificationType type)
	{
		Topic mp = new Topic(-1, null);
		int nbMps = 0;
		try
		{
			nbMps = getDataRetriever().countNewMps(mp);
		}
		catch (DataRetrieverException e)
		{
			Log.e(HFR4droidApplication.TAG, HFR4droidActivity.getMessage(e, null), e);
		}
		notifyNewMps(nbMps, mp, type);
	}

	private MDDataRetriever getDataRetriever()
	{
		return ((HFR4droidApplication) getApplication()).getDataRetriever();
	}
}
