package info.toyonos.hfr4droid.core.data;

import info.toyonos.hfr4droid.core.bean.BasicElement;
import info.toyonos.hfr4droid.core.bean.Topic.TopicType;

/**
 * <p>Interface dfinissant le moyen de parser des url sur un forum 
 * de discussion MesDiscussions.net</p>
 * 
 * @author ToYonos
 *  
 */
public interface MDUrlParser
{
	/**
	 * Parse une url donne
	 * @param url L'url  parser
	 * @return true le parsing  russi, false sinon
	 */
	public boolean parseUrl(String url) throws DataRetrieverException;
	
	/**
	 * Renvoie le <code>BasicElement</code> correspondant aux donnes de l'url
	 * @return <ul>
	 * <li>Si c'est une url qui va lister les catgories, null sera renvoy</li>
	 * <li>Si c'est une url qui va lister les topics d'une catgorie, une instance de <code>Categorie</code> sera renvoye</li>
	 * <li>Si c'est une url qui va lister les posts d'un topic, une instance de <code>Topic</code> sera renvoye</li>
	 * </ul>
	 */
	public BasicElement getElement();

	/**
	 * Renvoie le numro de page trouv dans l'url
	 * @return le numro de page ou -1 si aucune page n'a t spcifie
	 */
	public int getPage();
	
	/**
	 * Renvoie le type de topic trouv dans l'url
	 * @return le type de topic et par dfaut <code>TopicType.ALL</code> si rien n'a t spcifi
	 */
	public TopicType getType();
}