/*
 * This file is part of nori.
 * Copyright (c) 2014-2016 Tomasz Jan Góralczyk <tomg@fastmail.uk>
 * License: GNU GPLv2
 */

package io.github.tjg1.nori.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.widget.ImageView;

/** A {@link android.widget.ImageView} widget forcefully maintaining a 1:1 aspect ratio. */
public class SquareImageView extends ImageView {

  //region Constructors
  public SquareImageView(Context context) {
    super(context);
  }

  public SquareImageView(Context context, AttributeSet attrs) {
    super(context, attrs);
  }

  public SquareImageView(Context context, AttributeSet attrs, int defStyle) {
    super(context, attrs, defStyle);
  }
  //endregion

  //region View methods (Force square layout)
  @Override
  protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
    super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    // Force 1:1 aspect ratio.
    setMeasuredDimension(getMeasuredWidth(), getMeasuredWidth());
  }
  //endregion
}
