/*************************************************************************/
/*  concave_polygon_shape.h                                              */
/*************************************************************************/
/*                       This file is part of:                           */
/*                           GODOT ENGINE                                */
/*                    http://www.godotengine.org                         */
/*************************************************************************/
/* Copyright (c) 2007-2017 Juan Linietsky, Ariel Manzur.                 */
/*                                                                       */
/* Permission is hereby granted, free of charge, to any person obtaining */
/* a copy of this software and associated documentation files (the       */
/* "Software"), to deal in the Software without restriction, including   */
/* without limitation the rights to use, copy, modify, merge, publish,   */
/* distribute, sublicense, and/or sell copies of the Software, and to    */
/* permit persons to whom the Software is furnished to do so, subject to */
/* the following conditions:                                             */
/*                                                                       */
/* The above copyright notice and this permission notice shall be        */
/* included in all copies or substantial portions of the Software.       */
/*                                                                       */
/* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,       */
/* EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF    */
/* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.*/
/* IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY  */
/* CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,  */
/* TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE     */
/* SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.                */
/*************************************************************************/
#ifndef CONCAVE_POLYGON_SHAPE_H
#define CONCAVE_POLYGON_SHAPE_H

#include "scene/resources/shape.h"

class ConcavePolygonShape : public Shape {

	OBJ_TYPE(ConcavePolygonShape,Shape);

	struct DrawEdge {

		Vector3 a;
		Vector3 b;
		bool operator<(const DrawEdge& p_edge) const {
			if (a==p_edge.a)
				return b<p_edge.b;
			else
				return a<p_edge.a;
		}

		DrawEdge(const Vector3& p_a=Vector3(),const Vector3& p_b=Vector3()) {
			a=p_a;
			b=p_b;
			if (a<b) {
				SWAP(a,b);
			}
		}
	};

protected:


	bool _set(const StringName& p_name, const Variant& p_value);
	bool _get(const StringName& p_name,Variant &r_ret) const;
	void _get_property_list( List<PropertyInfo> *p_list) const;
	static void _bind_methods();

	virtual void _update_shape();
	virtual Vector<Vector3> _gen_debug_mesh_lines();
public:

	void set_faces(const DVector<Vector3>& p_faces);
	DVector<Vector3> get_faces() const;


	ConcavePolygonShape();
};

#endif // CONCAVE_POLYGON_SHAPE_H
