#!/usr/bin/env python

import os
import glob
import string


# Generate include files

f = open("theme_data.h", "wb")

f.write("// THIS FILE HAS BEEN AUTOGENERATED, DONT EDIT!!\n")

# Generate png image block
f.write("\n// png image block\n");

pixmaps = glob.glob("*.png")
pixmaps.sort()

for x in pixmaps:

    var_str = x[:-4] + "_png"

    f.write("\nstatic const unsigned char " + var_str + "[] = {\n\t")

    pngf = open(x, "rb")

    b = pngf.read(1)
    while(len(b) == 1):
        f.write(hex(ord(b)))
        b = pngf.read(1)
        if (len(b) == 1):
            f.write(", ")

    f.write("\n};\n")
    pngf.close()

# Generate shaders block
f.write("\n// shaders block\n");

shaders = glob.glob("*.gsl")
shaders.sort()

for x in shaders:

    var_str = x[:-4] + "_shader_code"

    f.write("\nstatic const char *" + var_str + " =\n")

    sf = open(x, "rb")

    b = sf.readline()
    while(b != ""):
        if (b.endswith("\r\n")):
            b = b[:-2]
        if (b.endswith("\n")):
            b = b[:-1]
        f.write("\t\t\"" + b)
        b = sf.readline()
        if (b != ""):
            f.write("\"\n")

    f.write("\";\n")
    sf.close()

f.close()
