package it.devapp.android;
/* -------------------------------------------------
 * Autore : Francesco Colucci 2012
 */
import java.util.ArrayList;

import android.app.ListActivity;
// import android.content.ContentUris;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.provider.ContactsContract;
//import android.provider.ContactsContract.Profile;
//import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
// import android.widget.Button;
import android.widget.ListView;
import android.widget.SimpleCursorAdapter;
import android.widget.Toast;

public class ListContatti extends ListActivity 
{
	SimpleCursorAdapter adapter;
	ArrayList<String> nomi_list = new ArrayList<String>(10);
    ArrayList<String> numeri_list = new ArrayList<String>(10);
    
    Intent intent; // contiene l'intent per la restituzione dei dati
    int nro_contatti_selezionati;
    
	@Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.contatti);
        nro_contatti_selezionati = 0;      // azzera il numero di contatti selezionati
        
        //ottengo i dati proveninienti dall'activity chiamante
    	intent= getIntent();
        
    	//      Uri allContacts = ContactsContract.Profile.CONTENT_RAW_CONTACTS_URI;
        Uri allContacts = ContactsContract.Contacts.CONTENT_URI;
     //   Uri allContacts = ContentUris.withAppendedId(ContactsContract.Contacts.CONTENT_URI, 1);
        String[] projection = new String[] 
            {ContactsContract.Contacts._ID, 
             ContactsContract.Contacts.DISPLAY_NAME,
             ContactsContract.Contacts.HAS_PHONE_NUMBER};
        
        Cursor c = managedQuery(
            allContacts,   // l'URI
            projection,    // colonne che si intendono estrarre dalla query
            ContactsContract.Contacts.DISPLAY_NAME + " LIKE ?",  // tutte le righe da estrarre
            new String[] {"%"} , 
            ContactsContract.Contacts.DISPLAY_NAME + " DESC");  // visualizza le righe in ordine decrescente di nome
        
        
        String[] columns = new String[] {ContactsContract.Contacts._ID, ContactsContract.Contacts.DISPLAY_NAME,};
        int[] views = new int[] {R.id.contactName,R.id.contactID};
        
        adapter = 
            new SimpleCursorAdapter(this, R.layout.contatti, c, columns, views);
        this.setListAdapter(adapter);
 
    } 
    
	public void aggiungi(String nome, String numero)
	{		
		boolean trovato;
				
		trovato = (nomi_list.indexOf(nome) != -1);
		if (trovato)
		{	
		  Toast.makeText(this, "Contact has already been added!", Toast.LENGTH_SHORT).show();
		}		
		if ((nomi_list.size() <= 9) && (trovato == false))   // aggiunge al massimo 10 contatti: da 0 a 9
		{	
		  numero = numero.replaceAll("-", "");  // toglie dal numero gli eventuali trattini aggiunti automaticamente dalla rubrica Android
		  numero = numero.replaceAll(" ", "");  // toglie dal numero gli eventuali spazi aggiunti automaticamente dalla rubrica Android
		  nomi_list.add(nome);
		  numeri_list.add(numero);
	      Toast.makeText(this, "selected: " + nome + " " + numero, Toast.LENGTH_LONG).show();
	      nro_contatti_selezionati++;  // incrementa il numero di contatti selezionati
		}
		if (nomi_list.size() == 10)
		
			Toast.makeText(this, "Already added 10 contacts!", Toast.LENGTH_LONG).show();
	}
	
    @Override    
	protected void onListItemClick(ListView l, View v, int position, long id) 
    {
    	String number = "";
    	
    	super.onListItemClick(l, v, position, id);
    	
        Cursor cursor = (Cursor) adapter.getItem(position);
        String contactDisplayName = cursor.getString(cursor.getColumnIndex(ContactsContract.Contacts.DISPLAY_NAME)); 
        String contactID = cursor.getString(cursor.getColumnIndex(ContactsContract.Contacts._ID));
        int hasPhone = cursor.getInt(cursor.getColumnIndex(ContactsContract.Contacts.HAS_PHONE_NUMBER));
               
        if (hasPhone == 1) {        // il contatto ha il numero di telefono?
            Cursor phoneCursor = getContentResolver().query(
              ContactsContract.CommonDataKinds.Phone.CONTENT_URI, null, 
              ContactsContract.CommonDataKinds.Phone.CONTACT_ID + " = " + contactID, null, null);                     
            while (phoneCursor.moveToNext()) 
            {
              number =  phoneCursor.getString(phoneCursor.getColumnIndex(ContactsContract.CommonDataKinds.Phone.NUMBER));
            } 
            phoneCursor.close();
        }
        else
        { 
           Toast.makeText(this, "selected: " + contactDisplayName + " without number", Toast.LENGTH_LONG).show();
           number = "";
        }
    
        aggiungi(contactDisplayName,number);
	}
    
    public boolean onCreateOptionsMenu(Menu menu)
	{
		getMenuInflater().inflate(R.menu.menu_contatti, menu);
		return true;
	}
    
	public boolean onOptionsItemSelected(MenuItem item)
	{
		switch (item.getItemId())
		{
		  // pressione di Done
		  case R.id.item1:
		    finish();
			return true;
		  
	      // pressione di Cancel	
		  case R.id.item2:  // annulla tutte le selezioni eventualmente fatte
		    if (nro_contatti_selezionati > 0) // se sono stati selezionati dei contatti.....
		    {	
			  Toast.makeText(this, "All selected contacts will be removed", Toast.LENGTH_LONG).show();
			  nomi_list.clear();  // rimuove tutti i nomi in nomi_list
			  numeri_list.clear();  // rimuove tutti i numeri in numeri_list
			  nro_contatti_selezionati = 0;   // non ci sono più contatti selezionati
		    }
		    finish();
			return true;

		}
		return super.onOptionsItemSelected(item);
	}
       
    public void finish() {
    	
    	// Quando l'activity termina, prepara le liste da restituire a GeoActivity 
    	
 //       Toast.makeText(this, "Sono in finish() di ListContatti", Toast.LENGTH_LONG).show();
       	intent.putStringArrayListExtra("it.devapp.android.NOMI", nomi_list);
    	intent.putStringArrayListExtra("it.devapp.android.NUMERI", numeri_list);
    	if (nro_contatti_selezionati > 0)
    	  setResult(RESULT_OK, intent);        // restituisce un risultato OK  
    	else
    	  setResult(RESULT_CANCELED, intent);  // restituisce come risultato CANCELED
    	    	
    	super.finish();
    }

    
}
