package it.devapp.android;
/* -------------------------------------------------
 * Autore : Francesco Colucci 2012
 */
import android.app.Activity;
import android.app.PendingIntent;
import android.content.Intent;
import android.os.Bundle;
import android.telephony.SmsManager;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Toast;

import it.devapp.android.SimpleCrypto;
// ------------------------------------------
// INVIO SMS ad un altro utente sulla mappa
// ------------------------------------------
public class SmsActivity extends Activity 
{
    Button btnSendSMS;
    Button btnChiudi;
    Intent intent1;
    EditText txtMessage;
    String numero_tel;
 
    /** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) 
    {
        super.onCreate(savedInstanceState);
        
        // legge l'intent passato da GeoActivity
        intent1= getIntent();
        
        // legge il numero di telefono passato da Geoactivity a cui deve inviare l'SMS
        if (intent1.getStringExtra("it.devapp.android.NUMERO_SMS") != null)
        {
          numero_tel = intent1.getStringExtra("it.devapp.android.NUMERO_SMS");
     //     Toast.makeText(getApplicationContext(), "numero_tel != null", Toast.LENGTH_LONG).show();
        }
        else
        {	
          numero_tel = "";
   //       Toast.makeText(getApplicationContext(), "numero_tel == null", Toast.LENGTH_LONG).show();
        }
        
    	setContentView(R.layout.sms_form);        
        txtMessage = (EditText) findViewById(R.id.txtMessage);
        
        btnSendSMS = (Button) findViewById(R.id.btnSendSMS);
        btnSendSMS.setOnClickListener(new View.OnClickListener() 
        {
            public void onClick(View v) 
            {                
       
                String message = txtMessage.getText().toString(); 
                
                if (numero_tel.length()>0 && message.length()>0)                
                    sendSMS(numero_tel, message);                
                else
                    Toast.makeText(getBaseContext(),"Please enter both phone number and message.", Toast.LENGTH_SHORT).show();
            }
        });
        
        btnChiudi = (Button) findViewById(R.id.btnChiudiSMS);
        btnChiudi.setOnClickListener(new View.OnClickListener() 
        {
            public void onClick(View v) 
            {                
                finish();
            }
        });
    } 
    
  //---sends an SMS message to another device---
    private void sendSMS(String phoneNumber, String message)
    {   
    	String crypto;
    	
    	try 
    	{
		  crypto = SimpleCrypto.encrypt("xx12Tsa9", message);
		
    	  PendingIntent pi = PendingIntent.getActivity(this, 0,
          new Intent(this, SmsActivity.class), 0);                
          SmsManager sms = SmsManager.getDefault();
       // invia il messaggio criptato
          sms.sendTextMessage(phoneNumber, null, crypto, pi, null); 
    	} catch (Exception e) 
    	{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}      
    }    
    
    
  
}