package it.devapp.android;
/* -------------------------------------------------
 * Autore : Francesco Colucci 2012
 */
import android.content.BroadcastReceiver;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.content.LocalBroadcastManager;
import android.telephony.SmsMessage;

 
// --------------------------------------------------------------
// Riceve gli SMS degli altri utenti che hanno cambiato posizione
// Invia a Geoactivity 
// --------------------------------------------------------------

public class SmsReceiver extends BroadcastReceiver
{
	Intent broadcastIntent;
	LocalBroadcastManager mLocalBroadcastManager;
	
	
  //  String LONGITUDINE, LATITUDINE;
	@Override
    public void onReceive(Context context, Intent intent) 
    {
		String intest = "";
        String origin ="";  // mittente
        String str = "";   
        String lon, lat;
        String coordinate = "";
        String[] coord;
        String nome_papa = "";
		
        mLocalBroadcastManager = LocalBroadcastManager.getInstance(context);
        
		//---get the SMS message passed in---
        Bundle bundle = intent.getExtras();        
        SmsMessage[] msgs = null;
                
        if (bundle != null)
        {
        	broadcastIntent = new Intent();
        	//---retrieve the SMS message received---
            Object[] pdus = (Object[]) bundle.get("pdus");
            msgs = new SmsMessage[pdus.length];            
            for (int i=0; i<msgs.length; i++)
            {
                msgs[i] = SmsMessage.createFromPdu((byte[])pdus[i]);                
            //    str += "SMS from " + msgs[i].getOriginatingAddress();                     
            //    str += " :";
                str += msgs[i].getMessageBody();
            //    str += "\n";  
                origin += msgs[i].getOriginatingAddress();
            }
            // in str c'è il messaggio arrivato cifrato,... lo decripta
            try 
            {
				String cleartext = SimpleCrypto.decrypt("xx12Tsa9", str);
				intest = cleartext.substring(0, 5);
                
	            // inviato da un figlio al Papà per comunicare la sua posizione al genitore
	            if ( intest.equals("?pos:") ) 
	            {	
	               // un messaggio è nella forma "#pos:lon lat"
	              // toglie l'intestazione dal messaggio ottenendo solo le coordinate nel formato "lon lat"
	              coordinate = cleartext.substring(5);
	             
	              // ora estrae le coordinate nel vettore di stringhe coord
	              coord = coordinate.split(" ",2);
	              lon = coord[0];
	              lat = coord[1];
	              // Toast.makeText(context, "è arrivato lon:" + lon + " lat: " + lat, Toast.LENGTH_LONG).show();
	              // ora ritorna al broadcast receiver di geoactivity quanto ricevuto
	             
	              //---send a broadcast intent to update the SMS received in the activity---
	              broadcastIntent.setAction("SMS_RECEIVED_ACTION");
	              broadcastIntent.putExtra("it.devapp.android.INTESTAZIONE", intest);
	              broadcastIntent.putExtra("it.devapp.android.LONGITUDINE", lon);
	              broadcastIntent.putExtra("it.devapp.android.LATITUDINE", lat);
	              broadcastIntent.putExtra("it.devapp.android.TEL", origin);
	              mLocalBroadcastManager.sendBroadcast(broadcastIntent);
	  
	            }
	            else
	         // se l'intestazione è di un SMS di un papà che richiede al figlio l'invio della sua posizione
	            if ( intest.equals("?nam:") ) 
	            {
	            	// passa a Geoactivity il numero di telefono del Papà che ha richiesto la posizione e il nome
	            	// Geoactivity invierà la sua posizione a questo numero.
	            	
	            	// toglie l'intestazione dal messaggio ottenendo il nome di Papà
	                nome_papa = cleartext.substring(5);
	                
	            	broadcastIntent.setAction("SMS_RECEIVED_ACTION");
	                broadcastIntent.putExtra("it.devapp.android.INTESTAZIONE", intest);
	                broadcastIntent.putExtra("it.devapp.android.PAPA_NUMBER", origin);
	                broadcastIntent.putExtra("it.devapp.android.PAPA_NAME", nome_papa);
	                mLocalBroadcastManager.sendBroadcast(broadcastIntent);
	       /*     	
	            	
	            	Intent i = new Intent(context, GeoActivity.class);
	                i.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
	                i.putExtra("it.devapp.android.PAPA_NUMBER", origin);
	                context.startActivity(i);
	       */         
	            }
	            else
	            if ( intest.equals("?ppa:") ) 
	            {
	            	// passa a Geoactivity la posizione di Papà
	            	// 
	            	// un messaggio è nella forma "#pos:lon lat"
	                // toglie l'intestazione dal messaggio ottenendo solo le coordinate nel formato "lon lat"
	                coordinate = cleartext.substring(5);
	                
	                // ora estrae le coordinate nel vettore di stringhe coord
	                coord = coordinate.split(" ",2);
	                lon = coord[0];
	                lat = coord[1];
	            	// toglie l'intestazione dal messaggio ottenendo il nome di Papà
	                nome_papa = cleartext.substring(5);
	                
	                broadcastIntent.setAction("SMS_RECEIVED_ACTION");
	                broadcastIntent.putExtra("it.devapp.android.INTESTAZIONE", intest);
	                broadcastIntent.putExtra("it.devapp.android.LONGITUDINE", lon);
	                broadcastIntent.putExtra("it.devapp.android.LATITUDINE", lat);
	                broadcastIntent.putExtra("it.devapp.android.POS_PAPA", origin);
	                mLocalBroadcastManager.sendBroadcast(broadcastIntent);
	          
	            }
	            else
	            {
	            	// passa al broadcastReceiver di Geoactivity solo il num. tel. mittente (origin) e il messaggio decriptato
	            	broadcastIntent.setAction("SMS_RECEIVED_ACTION");
	            	broadcastIntent.putExtra("it.devapp.android.MITTENTE", origin);
	            	broadcastIntent.putExtra("it.devapp.android.MESSAGGIO", cleartext);
	            	mLocalBroadcastManager.sendBroadcast(broadcastIntent);
	            }
			} catch (Exception e) 
			  {
				// TODO Auto-generated catch block
				e.printStackTrace();
			  }
               
        }
    //    Toast.makeText(context, "il mittente è: " + origin, Toast.LENGTH_LONG).show();
    }
}
