/*
*   it.rgp.nyagua.pafcalc.PAFCalc - Planted Aquarium Fertilizer Calculator
*   Copyright (C) 2013 Rudi Giacomini Pilon
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with this program; if not, write to the Free Software Foundation, Inc.,
* 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*
*/
package it.rgp.nyagua.pafcalc;

import android.app.Activity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;

import java.util.ArrayList;

/**
 * This is the GridView adapter to have Text+Text tiles
 *
 *  @author Rudi Giacomini Pilon on 19/11/13.
 */
public class CellsAdapter extends BaseAdapter
{
    private ArrayList<String> ListHeaders;
    private ArrayList<String> listCells;
    private Activity activity;

    public CellsAdapter(Activity activity, ArrayList<String> ListHeaders, ArrayList<String> listCells) {
        super();
        this.ListHeaders = ListHeaders;
        this.listCells = listCells;
        this.activity = activity;
    }

    @Override
    public int getCount() {
        return ListHeaders.size();
    }

    @Override
    public String getItem(int position) {
        return ListHeaders.get(position);
    }

    @Override
    public long getItemId(int position) {
        return 0;
    }

    public static class ViewHolder
    {
        public TextView cellTextView;
        public TextView headerTextView;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder view;
        LayoutInflater inflator = activity.getLayoutInflater();

        if(convertView==null)
        {
            view = new ViewHolder();
            convertView = inflator.inflate(R.layout.cellview, null);
            view.headerTextView = (TextView) convertView.findViewById(R.id.headerTextView);
            view.cellTextView = (TextView) convertView.findViewById(R.id.cellTextView);
            convertView.setTag(view);
        }
        else
        {
            view = (ViewHolder) convertView.getTag();
        }

        view.headerTextView.setText(ListHeaders.get(position));
        view.cellTextView.setText(listCells.get(position));

        return convertView;
    }
}


