/*
*   it.rgp.nyagua.pafcalc.PAFCalc - Planted Aquarium Fertilizer Calculator
*   Copyright (C) 2013 Rudi Giacomini Pilon
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with this program; if not, write to the Free Software Foundation, Inc.,
* 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*
*/
package it.rgp.nyagua.pafcalc;

import android.app.Activity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;

import java.util.ArrayList;

/**
 * This is the GridView adapter to have Image+Text tiles
 *
 *  @author Rudi Giacomini Pilon on 19/11/13.
 */
public class GridviewAdapter extends BaseAdapter
{
    private ArrayList<String> listMethods;
    private ArrayList<Integer> listImages;
    private Activity activity;

    public GridviewAdapter(Activity activity,ArrayList<String> listMethods, ArrayList<Integer> listImages) {
        super();
        this.listMethods = listMethods;
        this.listImages = listImages;
        this.activity = activity;
    }

    @Override
    public int getCount() {
        return listMethods.size();
    }

    @Override
    public String getItem(int position) {
        return listMethods.get(position);
    }

    @Override
    public long getItemId(int position) {
        return 0;
    }

    public static class ViewHolder
    {
        public ImageView imgViewImage;
        public TextView txtViewTitle;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder view;
        LayoutInflater inflator = activity.getLayoutInflater();

        if(convertView==null)
        {
            view = new ViewHolder();
            convertView = inflator.inflate(R.layout.gridview_row, null);
            view.txtViewTitle = (TextView) convertView.findViewById(R.id.textView1);
            view.imgViewImage = (ImageView) convertView.findViewById(R.id.imageView1);
            convertView.setTag(view);
        }
        else
        {
            view = (ViewHolder) convertView.getTag();
        }

        view.txtViewTitle.setText(listMethods.get(position));
        view.imgViewImage.setImageResource(listImages.get(position));

        return convertView;
    }
}


