/*
*   it.rgp.nyagua.pafcalc.PAFCalc - Planted Aquarium Fertilizer Calculator
*   Copyright (C) 2013 Rudi Giacomini Pilon
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with this program; if not, write to the Free Software Foundation, Inc.,
* 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*
*/

/*
 * This calculator is heavily based on flores' yanc (Yet Another Nutrient Calculator)
 * at http://calc.petalphile.com/ shared as Open Source.
 * Thanks to mr. Flores for this concept piece.
 *
 */
package it.rgp.nyagua.pafcalc;

import android.app.Activity;
import android.content.Intent;
import android.content.res.Resources;
import android.os.Bundle;
import android.support.v4.app.NavUtils;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.AdapterView;
import android.widget.GridView;

import java.util.ArrayList;
import java.util.Collections;

/**
 * Main activity
 */
public class MainActivity extends Activity {

    //Methods
    public static final int METHOD_TARGET=0;
    public static final int METHOD_RESULT=1;
    public static final int METHOD_EI=2;
    public static final int METHOD_EID=3;
    public static final int METHOD_EIW=4;
    public static final int METHOD_PPS=5;
    public static final int METHOD_PMDD=6;
    public static final int METHOD_WALSTAD=1;//used in graphs

    public final static String EXTRA_METHOD = "it.rgp.nyagua.pafcalc.METHOD";

    private ArrayList<String> listMethods;
    private ArrayList<Integer> listImages;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        //User interface
        setContentView(R.layout.activity_main);
        prepareList();

        // prepared array list and passed it to the Adapter class
        GridviewAdapter mAdapter = new GridviewAdapter(this, listMethods, listImages);

        // Set custom adapter to grid view
        GridView gridView = (GridView) findViewById(R.id.gridView1);
        gridView.setAdapter(mAdapter);
        gridView.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> arg0, View arg1, int position, long arg3) {
                callAquariumListView(position);
            }
        });
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.main, menu);
        return true;
    }


    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case android.R.id.home:
                // This ID represents the Home or Up button. In the case of this
                // activity, the Up button is shown. Use NavUtils to allow users
                // to navigate up one level in the application structure. For
                // more details, see the Navigation pattern on Android Design:
                //
                // http://developer.android.com/design/patterns/navigation.html#up-vs-back
                //
                NavUtils.navigateUpFromSameTask(this);
                return true;
            case R.id.action_about:
                Intent intent = new Intent(this, AboutActivity.class);
                startActivity(intent);
                return true;
        }
        return super.onOptionsItemSelected(item);
    }

    /**
     * Call to Aquarium list passing method choose
     *
     * @param methodId  int method from constants
     */
    private void callAquariumListView (int methodId){
        Intent intent = new Intent(this, CalculatorActivity.class);
        intent.putExtra(EXTRA_METHOD, methodId);
        startActivity(intent);
    }


    public void prepareList()
    {
        Resources res = getResources();
        //Labels are here
        listMethods = new ArrayList<String>();
        Collections.addAll(listMethods, res.getStringArray(R.array.solutions_method));

        //Images here
        listImages = new ArrayList<Integer>();
        listImages.add(R.drawable.ic_dose);
        listImages.add(R.drawable.ic_mix);
        listImages.add(R.drawable.ic_ei);
        listImages.add(R.drawable.ic_ei_daily);
        listImages.add(R.drawable.ic_ei_weekly);
        listImages.add(R.drawable.ic_pps);
        listImages.add(R.drawable.ic_pmdd);
    }

}
