/*
 * Decompiled with CFR 0.152.
 */
package ee.ioc.phon.netspeechapi;

import ee.ioc.phon.netspeechapi.AbstractUserAgent;
import ee.ioc.phon.netspeechapi.MyFileUtils;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;

public class AudioUploader
extends AbstractUserAgent {
    public static final String DEFAULT_WS_URL = "http://bark.phon.ioc.ee/webtrans/upload_file.php";
    public static final String RESPONSE_HEADER_WEBTRANS_ID = "X-webtrans-id";
    private final String mWsUrl;
    private final String mDecodingSpeed = "FAST";
    private final boolean mIsSendEmail;
    private final String mEmail;

    public AudioUploader(String string, String string2, boolean bl) {
        this.mWsUrl = string;
        this.mEmail = string2;
        this.mIsSendEmail = bl;
    }

    public AudioUploader(String string, boolean bl) {
        this(DEFAULT_WS_URL, string, bl);
    }

    public AudioUploader(String string) {
        this(DEFAULT_WS_URL, string, false);
    }

    public String upload(File file, String string, int n) throws ClientProtocolException, IOException {
        MultipartEntity multipartEntity = this.createMultipartEntity(file, string, n);
        String string2 = this.postMultipartEntity(multipartEntity);
        return string2;
    }

    public String uploadFileUnderRandomName(File file, String string, int n) throws ClientProtocolException, IOException {
        String string2 = MyFileUtils.createRandomFilename(string);
        FileBody fileBody = new FileBody(file, string2, string, null);
        MultipartEntity multipartEntity = this.createMultipartEntity(fileBody, string, n);
        return this.postMultipartEntity(multipartEntity);
    }

    public MultipartEntity createMultipartEntity(File file, String string, int n) {
        return this.createMultipartEntity(new FileBody(file, string), string, n);
    }

    public MultipartEntity createMultipartEntity(FileBody fileBody, String string, int n) {
        MultipartEntity multipartEntity = new MultipartEntity(HttpMultipartMode.STRICT);
        try {
            multipartEntity.addPart("email", (ContentBody)new StringBody(this.mEmail, "text/plain", Charset.forName("UTF-8")));
            multipartEntity.addPart("MODEL_SAMPLE_RATE", (ContentBody)new StringBody(String.valueOf(n), "text/plain", Charset.forName("UTF-8")));
            multipartEntity.addPart("DECODING", (ContentBody)new StringBody("FAST", "text/plain", Charset.forName("UTF-8")));
            String string2 = "0";
            if (this.mIsSendEmail) {
                string2 = "1";
            }
            multipartEntity.addPart("SEND_EMAIL", (ContentBody)new StringBody(string2, "text/plain", Charset.forName("UTF-8")));
            multipartEntity.addPart("upload_wav", (ContentBody)fileBody);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        return multipartEntity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String postMultipartEntity(MultipartEntity multipartEntity) throws ClientProtocolException, IOException {
        DefaultHttpClient defaultHttpClient = new DefaultHttpClient();
        defaultHttpClient.getParams().setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_1);
        HttpPost httpPost = new HttpPost(this.mWsUrl);
        this.setUserAgent((HttpUriRequest)httpPost);
        httpPost.setEntity((HttpEntity)multipartEntity);
        String string = "";
        try {
            HttpResponse httpResponse = defaultHttpClient.execute((HttpUriRequest)httpPost);
            Header header = httpResponse.getFirstHeader(RESPONSE_HEADER_WEBTRANS_ID);
            if (header == null) {
                HttpEntity httpEntity = httpResponse.getEntity();
                string = EntityUtils.toString((HttpEntity)httpEntity, (String)"UTF-8");
            } else {
                string = header.getValue();
            }
        }
        finally {
            defaultHttpClient.getConnectionManager().shutdown();
        }
        return string;
    }
}

