/*
 * Decompiled with CFR 0.152.
 */
package ee.ioc.phon.netspeechapi;

import ee.ioc.phon.netspeechapi.AbstractUserAgent;
import ee.ioc.phon.netspeechapi.Utils;
import java.io.File;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.FileEntity;

public class Recognizer
extends AbstractUserAgent {
    public static final String DEFAULT_WS_URL = "http://bark.phon.ioc.ee/speech-api/v1/recognize";
    private final String mWsUrl;

    public Recognizer(String string) {
        this.mWsUrl = string;
    }

    public Recognizer() {
        this(DEFAULT_WS_URL);
    }

    public String recognize(File file, String string, int n) throws ClientProtocolException, IOException {
        return this.postFile(file, string, n);
    }

    public String recognize(byte[] byArray, String string, int n) throws ClientProtocolException, IOException {
        return this.postByteArray(byArray, string, n);
    }

    private String postFile(File file, String string, int n) throws ClientProtocolException, IOException {
        HttpPost httpPost = new HttpPost(this.mWsUrl);
        this.setUserAgent((HttpUriRequest)httpPost);
        FileEntity fileEntity = new FileEntity(file, string + "; rate=" + n);
        httpPost.setEntity((HttpEntity)fileEntity);
        return Utils.getResponseEntityAsString((HttpUriRequest)httpPost);
    }

    private String postByteArray(byte[] byArray, String string, int n) throws ClientProtocolException, IOException {
        HttpPost httpPost = new HttpPost(this.mWsUrl);
        this.setUserAgent((HttpUriRequest)httpPost);
        ByteArrayEntity byteArrayEntity = new ByteArrayEntity(byArray);
        byteArrayEntity.setContentType(string + "; rate=" + n);
        httpPost.setEntity((HttpEntity)byteArrayEntity);
        return Utils.getResponseEntityAsString((HttpUriRequest)httpPost);
    }
}

