/*
 * Decompiled with CFR 0.152.
 */
package ee.ioc.phon.netspeechapi;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlUtils {
    public static String getAttrValue(Node node, String string) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap == null) {
            return null;
        }
        Node node2 = namedNodeMap.getNamedItem(string);
        if (node2 == null) {
            return null;
        }
        return node2.getNodeValue();
    }

    public static Element getDocumentElement(File file) throws SAXException, IOException {
        DocumentBuilder documentBuilder = XmlUtils.getDocumentBuilder();
        Document document = documentBuilder.parse(file);
        Element element = document.getDocumentElement();
        if (element == null) {
            throw new SAXException("getDocumentElement() == null");
        }
        return element;
    }

    public static Element getDocumentElement(InputSource inputSource) throws SAXException, IOException {
        DocumentBuilder documentBuilder = XmlUtils.getDocumentBuilder();
        Document document = documentBuilder.parse(inputSource);
        Element element = document.getDocumentElement();
        if (element == null) {
            throw new SAXException("getDocumentElement() == null");
        }
        return element;
    }

    public static Element getChild(Node node, String string) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || !node2.getNodeName().equals(string)) continue;
            return (Element)node;
        }
        return null;
    }

    public static void getText(Node node, StringBuilder stringBuilder) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() == 3) {
                stringBuilder.append(' ');
                stringBuilder.append(node2.getNodeValue().trim());
                continue;
            }
            if (node2.getNodeType() != 1) continue;
            XmlUtils.getText(node2, stringBuilder);
        }
    }

    public static Map<String, String> load(Reader reader) throws SAXException, IOException {
        DocumentBuilder documentBuilder = XmlUtils.getDocumentBuilder();
        Document document = documentBuilder.parse(new InputSource(reader));
        document.getDocumentElement().normalize();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        XmlUtils.loadFromElements(hashMap, document.getDocumentElement().getChildNodes(), new StringBuffer(document.getDocumentElement().getNodeName()));
        return hashMap;
    }

    private static DocumentBuilder getDocumentBuilder() {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setExpandEntityReferences(true);
        documentBuilderFactory.setIgnoringComments(true);
        documentBuilderFactory.setNamespaceAware(false);
        documentBuilderFactory.setValidating(false);
        try {
            return documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException(parserConfigurationException);
        }
    }

    private static void loadFromElements(Map<String, String> map, NodeList nodeList, StringBuffer stringBuffer) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            String string = node.getNodeName();
            String string2 = null;
            NodeList nodeList2 = node.getChildNodes();
            if (nodeList2.getLength() > 0) {
                string2 = node.getChildNodes().item(0).getNodeValue();
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.append(".");
            }
            stringBuffer.append(string);
            if (string2 == null || string2.equals("")) {
                XmlUtils.loadFromElements(map, node.getChildNodes(), stringBuffer);
            } else {
                map.put(stringBuffer.toString(), string2);
            }
            if (stringBuffer.length() == string.length()) {
                stringBuffer.setLength(0);
                continue;
            }
            stringBuffer.setLength(stringBuffer.length() - (string.length() + 1));
        }
    }
}

