/*
 * Decompiled with CFR 0.152.
 */
package ee.ioc.phon.netspeechapi.recsession;

import ee.ioc.phon.netspeechapi.UserAgent;
import ee.ioc.phon.netspeechapi.recsession.ChunkedWebRecSessionResult;
import ee.ioc.phon.netspeechapi.recsession.NotAvailableException;
import ee.ioc.phon.netspeechapi.recsession.RecSession;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Properties;

public class ChunkedWebRecSession
implements RecSession,
UserAgent {
    public static final String CONF_BASE_URL = "base_url";
    public static final String CONTENT_TYPE = "audio/x-raw-int;rate=16000;channels=1;signed=true;endianness=1234;depth=16;width=16";
    public static final String USER_AGENT = "ChunkedWebRecSession/0.0.5";
    private String mContentType = "audio/x-raw-int;rate=16000;channels=1;signed=true;endianness=1234;depth=16;width=16";
    private String userAgent = "ChunkedWebRecSession/0.0.5";
    private Properties configuration = new Properties();
    private HttpURLConnection connection;
    private OutputStream out;
    private ChunkedWebRecSessionResult result;
    private boolean finished = false;

    public ChunkedWebRecSession(URL uRL) {
        this(uRL, null, null, 1);
    }

    public ChunkedWebRecSession(URL uRL, URL uRL2) {
        this(uRL, uRL2, null, 1);
    }

    public ChunkedWebRecSession(URL uRL, URL uRL2, String string) {
        this(uRL, uRL2, string, 1);
    }

    public ChunkedWebRecSession(URL uRL, URL uRL2, String string, int n) {
        if (uRL2 == null) {
            this.configuration.setProperty(CONF_BASE_URL, uRL.toExternalForm() + "?nbest=" + n);
        } else if (string == null) {
            this.configuration.setProperty(CONF_BASE_URL, uRL.toExternalForm() + "?lm=" + uRL2.toExternalForm() + "&nbest=" + n);
        } else {
            this.configuration.setProperty(CONF_BASE_URL, uRL.toExternalForm() + "?lm=" + uRL2.toExternalForm() + "&output-lang=" + string + "&nbest=" + n);
        }
    }

    public void create() throws IOException, NotAvailableException {
        URL uRL = new URL(this.configuration.getProperty(CONF_BASE_URL));
        this.connection = (HttpURLConnection)uRL.openConnection();
        this.connection.setChunkedStreamingMode(1024);
        this.connection.setRequestMethod("POST");
        this.connection.setDoOutput(true);
        this.connection.setDoInput(true);
        this.connection.setRequestProperty("Content-Type", this.mContentType);
        this.connection.setRequestProperty("User-Agent", this.userAgent);
        this.connection.connect();
        this.out = this.connection.getOutputStream();
    }

    public String getCurrentResult() throws IOException {
        if (this.result == null || this.result.getUtterances().isEmpty()) {
            return "";
        }
        return this.result.getUtterances().get(0);
    }

    public ChunkedWebRecSessionResult getResult() throws IOException {
        return this.result;
    }

    public boolean isFinished() {
        return this.finished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendChunk(byte[] byArray, boolean bl) throws IOException {
        if (byArray.length > 0) {
            this.out.write(byArray);
        }
        if (bl) {
            try {
                this.out.close();
                InputStream inputStream = this.connection.getInputStream();
                this.result = new ChunkedWebRecSessionResult(new InputStreamReader(inputStream));
            }
            finally {
                this.connection.disconnect();
                this.finished = true;
            }
        }
    }

    public Properties getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Properties properties) {
        this.configuration = properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        try {
            this.connection.disconnect();
        }
        catch (Exception exception) {
        }
        finally {
            this.finished = true;
        }
    }

    public void setContentType(String string) {
        this.mContentType = string;
    }

    public void setUserAgentComment(String string) {
        this.userAgent = "ChunkedWebRecSession/0.0.5 (" + string + ")";
    }
}

