/*
 * Decompiled with CFR 0.152.
 */
package ee.ioc.phon.netspeechapi.trans;

import ee.ioc.phon.netspeechapi.XmlUtils;
import ee.ioc.phon.netspeechapi.trans.Speaker;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Transcription {
    private static final String EL_TURN = "Turn";
    private static final String EL_SPEAKERS = "Speakers";
    private static final String EL_SPEAKER = "Speaker";
    private final Map<String, Speaker> mIdToSpeaker = new HashMap<String, Speaker>();
    private final Element mRoot;
    private final String mId;

    public Transcription(File file) throws SAXException, IOException {
        this.mRoot = XmlUtils.getDocumentElement(file);
        this.mId = this.createId();
        this.createIdToSpeaker();
    }

    public Transcription(InputSource inputSource) throws SAXException, IOException {
        this.mRoot = XmlUtils.getDocumentElement(inputSource);
        this.mId = this.createId();
        this.createIdToSpeaker();
    }

    public Element getRoot() {
        return this.mRoot;
    }

    public String getId() {
        return this.mId;
    }

    public NodeList getTurns() {
        return this.mRoot.getElementsByTagName(EL_TURN);
    }

    public String getTurnText(Node node) {
        StringBuilder stringBuilder = new StringBuilder();
        XmlUtils.getText(node, stringBuilder);
        return stringBuilder.toString();
    }

    public String getTurnSpeakerId(Node node) {
        return XmlUtils.getAttrValue(node, "speaker");
    }

    public int getTurnStartTime(Node node) {
        String string = XmlUtils.getAttrValue(node, "startTime");
        if (string == null) {
            return -1;
        }
        try {
            return Transcription.getMillis(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public String getPlainText() {
        NodeList nodeList = this.getTurns();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            XmlUtils.getText(nodeList.item(i), stringBuilder);
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    public List<Integer> getSyncPoints() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        NodeList nodeList = this.mRoot.getElementsByTagName("Sync");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string = XmlUtils.getAttrValue(nodeList.item(i), "time");
            if (string == null) continue;
            try {
                arrayList.add(Transcription.getMillis(string));
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return arrayList;
    }

    public Map<String, Speaker> getIdToSpeaker() {
        return this.mIdToSpeaker;
    }

    public Set<String> getSpeakerIds() {
        return this.mIdToSpeaker.keySet();
    }

    private String createId() {
        NodeList nodeList = this.mRoot.getElementsByTagName("Trans");
        String string = null;
        if (nodeList.getLength() > 0) {
            return XmlUtils.getAttrValue(nodeList.item(0), "audio_filename");
        }
        return string;
    }

    private void createIdToSpeaker() {
        Element element = XmlUtils.getChild(this.mRoot, EL_SPEAKERS);
        if (element != null) {
            NodeList nodeList = element.getElementsByTagName(EL_SPEAKER);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                NamedNodeMap namedNodeMap = nodeList.item(i).getAttributes();
                if (namedNodeMap == null) continue;
                Node node = namedNodeMap.getNamedItem("id");
                Node node2 = namedNodeMap.getNamedItem("name");
                Node node3 = namedNodeMap.getNamedItem("type");
                if (node == null) continue;
                String string = node.getNodeValue();
                String string2 = this.mId + "_" + string;
                if (node2 != null && node3 != null) {
                    this.mIdToSpeaker.put(string, new Speaker(string2, node2.getNodeValue(), node3.getNodeValue()));
                    continue;
                }
                this.mIdToSpeaker.put(string, new Speaker(string2));
            }
        }
    }

    private static int getMillis(String string) {
        return (int)(Float.parseFloat(string) * 1000.0f);
    }
}

