/*
 * Copyright 2011, Institute of Cybernetics at Tallinn University of Technology
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package kaljurand_at_gmail_dot_com.diktofon.activity;

import kaljurand_at_gmail_dot_com.diktofon.R;
import android.app.Activity;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.PackageManager.NameNotFoundException;
import android.os.Bundle;
import android.widget.TextView;
import android.text.Html;
import android.text.method.LinkMovementMethod;
import android.util.Log;

public class AboutActivity extends Activity {

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.about);

		TextView textview = (TextView) findViewById(R.id.tv_about);
		textview.setMovementMethod(LinkMovementMethod.getInstance());
		String about = String.format(getString(R.string.about), getString(R.string.app_name), getVersionName());
		textview.setText(Html.fromHtml(about));
	}


	private String getVersionName() {
		PackageInfo info = getPackageInfo();
		if (info == null) {
			return "?.?.?";
		}
		return info.versionName;
	}


	private PackageInfo getPackageInfo() {
		PackageManager manager = getPackageManager();
		try {
			return manager.getPackageInfo(getPackageName(), 0);
		} catch (NameNotFoundException e) {
			Log.e(AboutActivity.class.getName(), "Couldn't find package information in PackageManager", e);
		}
		return null;
	}

}
