/*
 * Decompiled with CFR 0.152.
 */
package ee.ioc.phon.netspeechapi;

import ee.ioc.phon.netspeechapi.AbstractUserAgent;
import ee.ioc.phon.netspeechapi.MyFileUtils;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;

public class AudioUploader
extends AbstractUserAgent {
    public static final String DEFAULT_WS_URL = "http://bark.phon.ioc.ee/webtrans/upload_file.php";
    public static final String RESPONSE_HEADER_WEBTRANS_ID = "X-webtrans-id";
    private final String mWsUrl;
    private final String mDecodingSpeed = "FAST";
    private final boolean mIsSendEmail;
    private final String mEmail;

    public AudioUploader(String wsUrl, String email, boolean isSendEmail) {
        this.mWsUrl = wsUrl;
        this.mEmail = email;
        this.mIsSendEmail = isSendEmail;
    }

    public AudioUploader(String email, boolean isSendEmail) {
        this(DEFAULT_WS_URL, email, isSendEmail);
    }

    public AudioUploader(String email) {
        this(DEFAULT_WS_URL, email, false);
    }

    public String upload(File file, String mimeType, int sampleRate) throws ClientProtocolException, IOException {
        MultipartEntity entity = this.createMultipartEntity(file, mimeType, sampleRate);
        String str = this.postMultipartEntity(entity);
        return str;
    }

    public String uploadFileUnderRandomName(File file, String mimeType, int sampleRate) throws ClientProtocolException, IOException {
        String filename = MyFileUtils.createRandomFilename(mimeType);
        FileBody fileBody = new FileBody(file, filename, mimeType, null);
        MultipartEntity entity = this.createMultipartEntity(fileBody, mimeType, sampleRate);
        return this.postMultipartEntity(entity);
    }

    public MultipartEntity createMultipartEntity(File file, String mimeType, int sampleRate) {
        return this.createMultipartEntity(new FileBody(file, mimeType), mimeType, sampleRate);
    }

    public MultipartEntity createMultipartEntity(FileBody fileBody, String mimeType, int sampleRate) {
        MultipartEntity entity = new MultipartEntity(HttpMultipartMode.STRICT);
        try {
            entity.addPart("email", (ContentBody)new StringBody(this.mEmail, "text/plain", Charset.forName("UTF-8")));
            entity.addPart("MODEL_SAMPLE_RATE", (ContentBody)new StringBody(String.valueOf(sampleRate), "text/plain", Charset.forName("UTF-8")));
            entity.addPart("DECODING", (ContentBody)new StringBody("FAST", "text/plain", Charset.forName("UTF-8")));
            String sendEmailAsString = "0";
            if (this.mIsSendEmail) {
                sendEmailAsString = "1";
            }
            entity.addPart("SEND_EMAIL", (ContentBody)new StringBody(sendEmailAsString, "text/plain", Charset.forName("UTF-8")));
            entity.addPart("upload_wav", (ContentBody)fileBody);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return entity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String postMultipartEntity(MultipartEntity entity) throws ClientProtocolException, IOException {
        DefaultHttpClient client = new DefaultHttpClient();
        client.getParams().setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_1);
        HttpPost post = new HttpPost(this.mWsUrl);
        this.setUserAgent((HttpUriRequest)post);
        post.setEntity((HttpEntity)entity);
        String responseAsString = "";
        try {
            HttpResponse response = client.execute((HttpUriRequest)post);
            Header header = response.getFirstHeader(RESPONSE_HEADER_WEBTRANS_ID);
            if (header == null) {
                HttpEntity responseEntity = response.getEntity();
                responseAsString = EntityUtils.toString((HttpEntity)responseEntity, (String)"UTF-8");
            } else {
                responseAsString = header.getValue();
            }
        }
        finally {
            client.getConnectionManager().shutdown();
        }
        return responseAsString;
    }
}

