/*
 * Decompiled with CFR 0.152.
 */
package ee.ioc.phon.netspeechapi.recsession;

import ee.ioc.phon.netspeechapi.UserAgent;
import ee.ioc.phon.netspeechapi.recsession.ChunkedWebRecSessionResult;
import ee.ioc.phon.netspeechapi.recsession.NotAvailableException;
import ee.ioc.phon.netspeechapi.recsession.RecSession;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class ChunkedWebRecSession
implements RecSession,
UserAgent {
    public static final String CONF_BASE_URL = "base_url";
    public static final String CONTENT_TYPE = "audio/x-raw-int;rate=16000;channels=1;signed=true;endianness=1234;depth=16;width=16";
    public static final String KEY_LANG = "lang";
    public static final String KEY_DEVICE_ID = "device_id";
    public static final String KEY_PHRASE = "phrase";
    public static final String USER_AGENT = "ChunkedWebRecSession/0.0.8";
    private static final int CHUNK_LENGTH = 0;
    private final Map<String, String> mParams = new HashMap<String, String>();
    private String mContentType = "audio/x-raw-int;rate=16000;channels=1;signed=true;endianness=1234;depth=16;width=16";
    private String userAgent = "ChunkedWebRecSession/0.0.8";
    private Properties configuration = new Properties();
    private HttpURLConnection connection;
    private OutputStream out;
    private ChunkedWebRecSessionResult result;
    private boolean finished = false;

    public ChunkedWebRecSession(URL wsUrl) {
        this(wsUrl, null, null, 1);
    }

    public ChunkedWebRecSession(URL wsUrl, URL lmUrl) {
        this(wsUrl, lmUrl, null, 1);
    }

    public ChunkedWebRecSession(URL wsUrl, URL lmUrl, String lang) {
        this(wsUrl, lmUrl, lang, 1);
    }

    public ChunkedWebRecSession(URL wsUrl, URL lmUrl, String lang, int nbest) {
        if (lmUrl == null) {
            this.configuration.setProperty(CONF_BASE_URL, wsUrl.toExternalForm() + "?nbest=" + nbest);
        } else if (lang == null) {
            this.configuration.setProperty(CONF_BASE_URL, wsUrl.toExternalForm() + "?lm=" + lmUrl.toExternalForm() + "&nbest=" + nbest);
        } else {
            this.configuration.setProperty(CONF_BASE_URL, wsUrl.toExternalForm() + "?lm=" + lmUrl.toExternalForm() + "&output-lang=" + lang + "&nbest=" + nbest);
        }
    }

    public void create() throws IOException, NotAvailableException {
        String urlAsString = this.configuration.getProperty(CONF_BASE_URL);
        for (String key : this.mParams.keySet()) {
            urlAsString = urlAsString + "&" + URLEncoder.encode(key, "utf-8") + "=" + URLEncoder.encode(this.mParams.get(key), "utf-8");
        }
        URL url = new URL(urlAsString);
        this.connection = (HttpURLConnection)url.openConnection();
        this.connection.setChunkedStreamingMode(0);
        this.connection.setRequestMethod("POST");
        this.connection.setDoOutput(true);
        this.connection.setDoInput(true);
        this.connection.setRequestProperty("Content-Type", this.mContentType);
        this.connection.setRequestProperty("User-Agent", this.userAgent);
    }

    public String getCurrentResult() throws IOException {
        if (this.result == null || this.result.getUtterances().isEmpty()) {
            return "";
        }
        return this.result.getUtterances().get(0);
    }

    public ChunkedWebRecSessionResult getResult() throws IOException {
        return this.result;
    }

    public boolean isFinished() {
        return this.finished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendChunk(byte[] bytes, boolean isLast) throws IOException {
        if (bytes.length > 0) {
            if (this.out == null) {
                this.out = new BufferedOutputStream(this.connection.getOutputStream());
            }
            this.out.write(bytes);
        }
        if (isLast) {
            try {
                if (this.out != null) {
                    this.out.close();
                }
                BufferedInputStream is = new BufferedInputStream(this.connection.getInputStream());
                this.result = new ChunkedWebRecSessionResult(new InputStreamReader(is));
            }
            finally {
                this.connection.disconnect();
                this.finished = true;
            }
        }
    }

    public Properties getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Properties configuration) {
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        try {
            this.connection.disconnect();
        }
        catch (Exception exception) {
        }
        finally {
            this.finished = true;
        }
    }

    public void setContentType(String contentType) {
        this.mContentType = contentType;
    }

    public void setUserAgentComment(String userAgentComment) {
        this.userAgent = "ChunkedWebRecSession/0.0.8 (" + userAgentComment + ")";
    }

    public void setLang(String lang) {
        this.setParam(KEY_LANG, lang);
    }

    public void setDeviceId(String deviceId) {
        this.setParam(KEY_DEVICE_ID, deviceId);
    }

    public void setPhrase(String phrase) {
        this.setParam(KEY_PHRASE, phrase);
    }

    public void setParam(String key, String value) {
        this.mParams.put(key, value);
    }
}

