/*
 * Decompiled with CFR 0.152.
 */
package ee.ioc.phon.netspeechapi.recsession;

import ee.ioc.phon.netspeechapi.recsession.Hypothesis;
import ee.ioc.phon.netspeechapi.recsession.Linearization;
import ee.ioc.phon.netspeechapi.recsession.RecSessionResult;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChunkedWebRecSessionResult
implements RecSessionResult {
    private final List<Hypothesis> mHypotheses = new ArrayList<Hypothesis>();
    private final List<String> mUtterances = new ArrayList<String>();
    private final List<String> mLinearizations = new ArrayList<String>();

    public ChunkedWebRecSessionResult(InputStreamReader reader) throws IOException {
        Object obj = JSONValue.parse((Reader)reader);
        if (obj == null) {
            throw new IOException("Server response is not well-formed");
        }
        JSONObject jsonObj = (JSONObject)obj;
        for (Object o1 : (JSONArray)jsonObj.get((Object)"hypotheses")) {
            JSONObject jo1 = (JSONObject)o1;
            this.add(this.mUtterances, jo1.get((Object)"utterance"));
            Object lins = jo1.get((Object)"linearizations");
            ArrayList<Linearization> linearizations = new ArrayList<Linearization>();
            if (lins != null) {
                for (Object o2 : (JSONArray)lins) {
                    JSONObject jo2 = (JSONObject)o2;
                    this.add(this.mLinearizations, jo2.get((Object)"output"));
                    String output = this.objToString(jo2.get((Object)"output"));
                    String lang = this.objToString(jo2.get((Object)"lang"));
                    linearizations.add(new Linearization(output, lang));
                }
            }
            this.mHypotheses.add(new Hypothesis(this.objToString(jo1.get((Object)"utterance")), linearizations));
        }
    }

    @Override
    public List<String> getLinearizations() {
        if (this.mLinearizations.isEmpty()) {
            return this.mUtterances;
        }
        return this.mLinearizations;
    }

    @Override
    public List<String> getUtterances() {
        return this.mUtterances;
    }

    @Override
    public List<Hypothesis> getHypotheses() {
        return this.mHypotheses;
    }

    private void add(List<String> list, Object obj) {
        String str;
        if (obj != null && (str = obj.toString()).length() > 0) {
            list.add(str);
        }
    }

    private String objToString(Object obj) {
        if (obj == null) {
            return null;
        }
        return obj.toString();
    }
}

