/*
 * Decompiled with CFR 0.152.
 */
package ee.ioc.phon.netspeechapi.trans;

import ee.ioc.phon.netspeechapi.XmlUtils;
import ee.ioc.phon.netspeechapi.trans.Tokenizer;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Turn {
    private static final String ATTR_SPEAKER = "speaker";
    private static final String ATTR_START_TIME = "startTime";
    private static final String ATTR_END_TIME = "endTime";
    private final Node mNode;
    private final String mText;
    private final Tokenizer mTokenizer;

    public Turn(Node node) {
        this.mNode = node;
        this.mText = Turn.createText(node);
        this.mTokenizer = new Tokenizer(this.mText);
    }

    public String getText() {
        return this.mText;
    }

    public List<String> getWords() {
        return this.mTokenizer.getWords();
    }

    public Set<String> getUniqueWords() {
        return this.mTokenizer.getUniqueWords();
    }

    public String getSpeakerId() {
        return XmlUtils.getAttrValue(this.mNode, ATTR_SPEAKER);
    }

    public int getStartTime() {
        return Turn.getAttrValueAsMillis(this.mNode, ATTR_START_TIME);
    }

    public int getEndTime() {
        return Turn.getAttrValueAsMillis(this.mNode, ATTR_END_TIME);
    }

    public int getDuration() {
        return this.getEndTime() - this.getStartTime();
    }

    private static int getAttrValueAsMillis(Node node, String attr) {
        String value = XmlUtils.getAttrValue(node, attr);
        if (value == null) {
            return -1;
        }
        try {
            return Turn.getMillis(value);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private static int getMillis(String timeAsString) {
        return (int)(Float.parseFloat(timeAsString) * 1000.0f);
    }

    private static String createText(Node node) {
        StringBuilder sb = new StringBuilder();
        XmlUtils.getText(node, sb);
        return sb.toString();
    }
}

