/*
 * Decompiled with CFR 0.152.
 */
package ee.ioc.phon.netspeechapi;

import ee.ioc.phon.netspeechapi.AbstractUserAgent;
import ee.ioc.phon.netspeechapi.Utils;
import java.io.File;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.FileEntity;

public class Recognizer
extends AbstractUserAgent {
    public static final String DEFAULT_WS_URL = "http://bark.phon.ioc.ee/speech-api/v1/recognize";
    private final String mWsUrl;

    public Recognizer(String wsUrl) {
        this.mWsUrl = wsUrl;
    }

    public Recognizer() {
        this(DEFAULT_WS_URL);
    }

    public String recognize(File file, String mimeType, int rate) throws ClientProtocolException, IOException {
        return this.postFile(file, mimeType, rate);
    }

    public String recognize(byte[] bytes, String mimeType, int rate) throws ClientProtocolException, IOException {
        return this.postByteArray(bytes, mimeType, rate);
    }

    private String postFile(File file, String mime, int rate) throws ClientProtocolException, IOException {
        HttpPost post = new HttpPost(this.mWsUrl);
        this.setUserAgent((HttpUriRequest)post);
        FileEntity entity = new FileEntity(file, mime + "; rate=" + rate);
        post.setEntity((HttpEntity)entity);
        return Utils.getResponseEntityAsString((HttpUriRequest)post);
    }

    private String postByteArray(byte[] bytes, String mime, int rate) throws ClientProtocolException, IOException {
        HttpPost post = new HttpPost(this.mWsUrl);
        this.setUserAgent((HttpUriRequest)post);
        ByteArrayEntity entity = new ByteArrayEntity(bytes);
        entity.setContentType(mime + "; rate=" + rate);
        post.setEntity((HttpEntity)entity);
        return Utils.getResponseEntityAsString((HttpUriRequest)post);
    }
}

