/*
 * Decompiled with CFR 0.152.
 */
package ee.ioc.phon.netspeechapi;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlUtils {
    public static String getAttrValue(Node node, String attrName) {
        NamedNodeMap nodeMap = node.getAttributes();
        if (nodeMap == null) {
            return null;
        }
        Node attr = nodeMap.getNamedItem(attrName);
        if (attr == null) {
            return null;
        }
        return attr.getNodeValue();
    }

    public static Element getDocumentElement(File xmlFile) throws SAXException, IOException {
        DocumentBuilder builder = XmlUtils.getDocumentBuilder();
        Document dom = builder.parse(xmlFile);
        Element root = dom.getDocumentElement();
        if (root == null) {
            throw new SAXException("getDocumentElement() == null");
        }
        return root;
    }

    public static Element getDocumentElement(InputSource is) throws SAXException, IOException {
        DocumentBuilder builder = XmlUtils.getDocumentBuilder();
        Document dom = builder.parse(is);
        Element root = dom.getDocumentElement();
        if (root == null) {
            throw new SAXException("getDocumentElement() == null");
        }
        return root;
    }

    public static Element getChild(Node node, String childName) {
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node childNode = children.item(i);
            if (childNode.getNodeType() != 1 || !childNode.getNodeName().equals(childName)) continue;
            return (Element)node;
        }
        return null;
    }

    public static void getText(Node node, StringBuilder sb) {
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() == 3) {
                sb.append(' ');
                sb.append(child.getNodeValue().trim());
                continue;
            }
            if (child.getNodeType() != 1) continue;
            XmlUtils.getText(child, sb);
        }
    }

    public static Map<String, String> load(Reader reader) throws SAXException, IOException {
        DocumentBuilder db = XmlUtils.getDocumentBuilder();
        Document doc = db.parse(new InputSource(reader));
        doc.getDocumentElement().normalize();
        HashMap<String, String> result = new HashMap<String, String>();
        XmlUtils.loadFromElements(result, doc.getDocumentElement().getChildNodes(), new StringBuffer(doc.getDocumentElement().getNodeName()));
        return result;
    }

    private static DocumentBuilder getDocumentBuilder() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setExpandEntityReferences(true);
        factory.setIgnoringComments(true);
        factory.setNamespaceAware(false);
        factory.setValidating(false);
        try {
            return factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    private static void loadFromElements(Map<String, String> result, NodeList nodeList, StringBuffer baseName) {
        for (int s = 0; s < nodeList.getLength(); ++s) {
            Node current = nodeList.item(s);
            if (current.getNodeType() != 1) continue;
            String name = current.getNodeName();
            String text = null;
            NodeList childNodes = current.getChildNodes();
            if (childNodes.getLength() > 0) {
                text = current.getChildNodes().item(0).getNodeValue();
            }
            if (baseName.length() > 0) {
                baseName.append(".");
            }
            baseName.append(name);
            if (text == null || text.equals("")) {
                XmlUtils.loadFromElements(result, current.getChildNodes(), baseName);
            } else {
                result.put(baseName.toString(), text);
            }
            if (baseName.length() == name.length()) {
                baseName.setLength(0);
                continue;
            }
            baseName.setLength(baseName.length() - (name.length() + 1));
        }
    }
}

