/*
 * Decompiled with CFR 0.152.
 */
package ee.ioc.phon.netspeechapi.trans;

import ee.ioc.phon.netspeechapi.XmlUtils;
import ee.ioc.phon.netspeechapi.trans.Speaker;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Transcription {
    private static final String EL_TURN = "Turn";
    private static final String EL_SPEAKERS = "Speakers";
    private static final String EL_SPEAKER = "Speaker";
    private static final String ATTR_START_TIME = "startTime";
    private static final String ATTR_END_TIME = "endTime";
    private final Map<String, Speaker> mIdToSpeaker = new HashMap<String, Speaker>();
    private final Element mRoot;
    private final String mId;

    public Transcription(File xmlFile) throws SAXException, IOException {
        this.mRoot = XmlUtils.getDocumentElement(xmlFile);
        this.mId = this.createId();
        this.createIdToSpeaker();
    }

    public Transcription(InputSource is) throws SAXException, IOException {
        this.mRoot = XmlUtils.getDocumentElement(is);
        this.mId = this.createId();
        this.createIdToSpeaker();
    }

    public Element getRoot() {
        return this.mRoot;
    }

    public String getId() {
        return this.mId;
    }

    public NodeList getTurns() {
        return this.mRoot.getElementsByTagName(EL_TURN);
    }

    public String getTurnText(Node turn) {
        StringBuilder sb = new StringBuilder();
        XmlUtils.getText(turn, sb);
        return sb.toString();
    }

    public String getTurnSpeakerId(Node turn) {
        return XmlUtils.getAttrValue(turn, "speaker");
    }

    public static String getSpeakerId(Node turn) {
        return XmlUtils.getAttrValue(turn, "speaker");
    }

    public int getTurnStartTime(Node turn) {
        return Transcription.getAttrValueAsMillis(turn, ATTR_START_TIME);
    }

    public static int getStartTime(Node turn) {
        return Transcription.getAttrValueAsMillis(turn, ATTR_START_TIME);
    }

    public static int getEndTime(Node turn) {
        return Transcription.getAttrValueAsMillis(turn, ATTR_END_TIME);
    }

    private static int getAttrValueAsMillis(Node node, String attr) {
        String value = XmlUtils.getAttrValue(node, attr);
        if (value == null) {
            return -1;
        }
        try {
            return Transcription.getMillis(value);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public String getPlainText() {
        NodeList turns = this.getTurns();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < turns.getLength(); ++i) {
            XmlUtils.getText(turns.item(i), sb);
            sb.append('\n');
        }
        return sb.toString();
    }

    public List<Integer> getSyncPoints() {
        ArrayList<Integer> syncPoints = new ArrayList<Integer>();
        NodeList nodeList = this.mRoot.getElementsByTagName("Sync");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String time = XmlUtils.getAttrValue(nodeList.item(i), "time");
            if (time == null) continue;
            try {
                syncPoints.add(Transcription.getMillis(time));
                continue;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return syncPoints;
    }

    public Map<String, Speaker> getIdToSpeaker() {
        return this.mIdToSpeaker;
    }

    public Set<String> getSpeakerIds() {
        return this.mIdToSpeaker.keySet();
    }

    private String createId() {
        NodeList nodeList = this.mRoot.getElementsByTagName("Trans");
        String id = null;
        if (nodeList.getLength() > 0) {
            return XmlUtils.getAttrValue(nodeList.item(0), "audio_filename");
        }
        return id;
    }

    private void createIdToSpeaker() {
        Element rootSpeakers = XmlUtils.getChild(this.mRoot, EL_SPEAKERS);
        if (rootSpeakers != null) {
            NodeList nodeList = rootSpeakers.getElementsByTagName(EL_SPEAKER);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                NamedNodeMap nodeMap = nodeList.item(i).getAttributes();
                if (nodeMap == null) continue;
                Node idNode = nodeMap.getNamedItem("id");
                Node nameNode = nodeMap.getNamedItem("name");
                Node typeNode = nodeMap.getNamedItem("type");
                if (idNode == null) continue;
                String localId = idNode.getNodeValue();
                String sId = this.mId + "_" + localId;
                if (nameNode != null && typeNode != null) {
                    this.mIdToSpeaker.put(localId, new Speaker(sId, nameNode.getNodeValue(), typeNode.getNodeValue()));
                    continue;
                }
                this.mIdToSpeaker.put(localId, new Speaker(sId));
            }
        }
    }

    private static int getMillis(String timeAsString) {
        return (int)(Float.parseFloat(timeAsString) * 1000.0f);
    }
}

