/*
 * Decompiled with CFR 0.152.
 */
package org.achartengine.chart;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import java.util.ArrayList;
import java.util.List;
import org.achartengine.chart.ClickableArea;
import org.achartengine.chart.PointStyle;
import org.achartengine.chart.ScatterChart;
import org.achartengine.chart.XYChart;
import org.achartengine.model.XYMultipleSeriesDataset;
import org.achartengine.renderer.SimpleSeriesRenderer;
import org.achartengine.renderer.XYMultipleSeriesRenderer;
import org.achartengine.renderer.XYSeriesRenderer;

public class LineChart
extends XYChart {
    public static final String TYPE = "Line";
    private static final int SHAPE_WIDTH = 30;
    private ScatterChart pointsChart;

    LineChart() {
    }

    public LineChart(XYMultipleSeriesDataset dataset, XYMultipleSeriesRenderer renderer) {
        super(dataset, renderer);
        this.pointsChart = new ScatterChart(dataset, renderer);
    }

    @Override
    protected void setDatasetRenderer(XYMultipleSeriesDataset dataset, XYMultipleSeriesRenderer renderer) {
        super.setDatasetRenderer(dataset, renderer);
        this.pointsChart = new ScatterChart(dataset, renderer);
    }

    @Override
    public void drawSeries(Canvas canvas, Paint paint, List<Float> points, SimpleSeriesRenderer seriesRenderer, float yAxisValue, int seriesIndex, int startIndex) {
        XYSeriesRenderer.FillOutsideLine[] fillOutsideLine;
        XYSeriesRenderer renderer = (XYSeriesRenderer)seriesRenderer;
        float lineWidth = paint.getStrokeWidth();
        paint.setStrokeWidth(renderer.getLineWidth());
        for (XYSeriesRenderer.FillOutsideLine fill : fillOutsideLine = renderer.getFillOutsideLine()) {
            float referencePoint;
            if (fill.getType() == XYSeriesRenderer.FillOutsideLine.Type.NONE) continue;
            paint.setColor(fill.getColor());
            ArrayList<Float> fillPoints = new ArrayList<Float>();
            int[] range = fill.getFillRange();
            if (range == null) {
                fillPoints.addAll(points);
            } else {
                fillPoints.addAll(points.subList(range[0] * 2, range[1] * 2));
            }
            switch (fill.getType()) {
                case BOUNDS_ALL: {
                    referencePoint = yAxisValue;
                    break;
                }
                case BOUNDS_BELOW: {
                    referencePoint = yAxisValue;
                    break;
                }
                case BOUNDS_ABOVE: {
                    referencePoint = yAxisValue;
                    break;
                }
                case BELOW: {
                    referencePoint = canvas.getHeight();
                    break;
                }
                case ABOVE: {
                    referencePoint = 0.0f;
                    break;
                }
                default: {
                    throw new RuntimeException("You have added a new type of filling but have not implemented.");
                }
            }
            if (fill.getType() == XYSeriesRenderer.FillOutsideLine.Type.BOUNDS_ABOVE || fill.getType() == XYSeriesRenderer.FillOutsideLine.Type.BOUNDS_BELOW) {
                ArrayList boundsPoints = new ArrayList();
                boolean add = false;
                if (fill.getType() == XYSeriesRenderer.FillOutsideLine.Type.BOUNDS_ABOVE && ((Float)fillPoints.get(1)).floatValue() < referencePoint || fill.getType() == XYSeriesRenderer.FillOutsideLine.Type.BOUNDS_BELOW && ((Float)fillPoints.get(1)).floatValue() > referencePoint) {
                    boundsPoints.add(fillPoints.get(0));
                    boundsPoints.add(fillPoints.get(1));
                    add = true;
                }
                for (int i = 3; i < fillPoints.size(); i += 2) {
                    float prevValue = ((Float)fillPoints.get(i - 2)).floatValue();
                    float value = ((Float)fillPoints.get(i)).floatValue();
                    if (prevValue < referencePoint && value > referencePoint || prevValue > referencePoint && value < referencePoint) {
                        float prevX = ((Float)fillPoints.get(i - 3)).floatValue();
                        float x = ((Float)fillPoints.get(i - 1)).floatValue();
                        boundsPoints.add(Float.valueOf(prevX + (x - prevX) * (referencePoint - prevValue) / (value - prevValue)));
                        boundsPoints.add(Float.valueOf(referencePoint));
                        if (fill.getType() == XYSeriesRenderer.FillOutsideLine.Type.BOUNDS_ABOVE && value > referencePoint || fill.getType() == XYSeriesRenderer.FillOutsideLine.Type.BOUNDS_BELOW && value < referencePoint) {
                            i += 2;
                            add = false;
                            continue;
                        }
                        boundsPoints.add(Float.valueOf(x));
                        boundsPoints.add(Float.valueOf(value));
                        add = true;
                        continue;
                    }
                    if (!(add || fill.getType() == XYSeriesRenderer.FillOutsideLine.Type.BOUNDS_ABOVE && value < referencePoint) && (fill.getType() != XYSeriesRenderer.FillOutsideLine.Type.BOUNDS_BELOW || !(value > referencePoint))) continue;
                    boundsPoints.add(fillPoints.get(i - 1));
                    boundsPoints.add(Float.valueOf(value));
                }
                fillPoints.clear();
                fillPoints.addAll(boundsPoints);
            }
            int length = fillPoints.size();
            fillPoints.set(0, Float.valueOf(((Float)fillPoints.get(0)).floatValue() + 1.0f));
            fillPoints.add((Float)fillPoints.get(length - 2));
            fillPoints.add(Float.valueOf(referencePoint));
            fillPoints.add((Float)fillPoints.get(0));
            fillPoints.add((Float)fillPoints.get(length + 1));
            for (int i = 0; i < length + 4; i += 2) {
                if (!(((Float)fillPoints.get(i + 1)).floatValue() < 0.0f)) continue;
                fillPoints.set(i + 1, Float.valueOf(0.0f));
            }
            paint.setStyle(Paint.Style.FILL);
            this.drawPath(canvas, fillPoints, paint, true);
        }
        paint.setColor(seriesRenderer.getColor());
        paint.setStyle(Paint.Style.STROKE);
        this.drawPath(canvas, points, paint, false);
        paint.setStrokeWidth(lineWidth);
    }

    @Override
    protected ClickableArea[] clickableAreasForPoints(List<Float> points, List<Double> values, float yAxisValue, int seriesIndex, int startIndex) {
        int length = points.size();
        ClickableArea[] ret = new ClickableArea[length / 2];
        for (int i = 0; i < length; i += 2) {
            int selectableBuffer = this.mRenderer.getSelectableBuffer();
            ret[i / 2] = new ClickableArea(new RectF(points.get(i).floatValue() - (float)selectableBuffer, points.get(i + 1).floatValue() - (float)selectableBuffer, points.get(i).floatValue() + (float)selectableBuffer, points.get(i + 1).floatValue() + (float)selectableBuffer), values.get(i), values.get(i + 1));
        }
        return ret;
    }

    @Override
    public int getLegendShapeWidth(int seriesIndex) {
        return 30;
    }

    @Override
    public void drawLegendShape(Canvas canvas, SimpleSeriesRenderer renderer, float x, float y, int seriesIndex, Paint paint) {
        canvas.drawLine(x, y, x + 30.0f, y, paint);
        if (this.isRenderPoints(renderer)) {
            this.pointsChart.drawLegendShape(canvas, renderer, x + 5.0f, y, seriesIndex, paint);
        }
    }

    @Override
    public boolean isRenderPoints(SimpleSeriesRenderer renderer) {
        return ((XYSeriesRenderer)renderer).getPointStyle() != PointStyle.POINT;
    }

    @Override
    public ScatterChart getPointsChart() {
        return this.pointsChart;
    }

    @Override
    public String getChartType() {
        return TYPE;
    }
}

