/*
 * AndFHEM - Open Source Android application to control a FHEM home automation
 * server.
 *
 * Copyright (c) 2011, Matthias Klass or third-party contributors as
 * indicated by the @author tags or express copyright attribution
 * statements applied by the authors.  All third-party contributions are
 * distributed under license by Red Hat Inc.
 *
 * This copyrighted material is made available to anyone wishing to use, modify,
 * copy, or redistribute it subject to the terms and conditions of the GNU GENERAL PUBLIC LICENSE, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU GENERAL PUBLIC LICENSE
 * for more details.
 *
 * You should have received a copy of the GNU GENERAL PUBLIC LICENSE
 * along with this distribution; if not, write to:
 *   Free Software Foundation, Inc.
 *   51 Franklin Street, Fifth Floor
 *   Boston, MA  02110-1301  USA
 */

package li.klass.fhem.adapter.devices.genericui;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.ResultReceiver;
import android.widget.TableRow;
import li.klass.fhem.constants.Actions;
import li.klass.fhem.constants.BundleExtraKeys;
import li.klass.fhem.domain.core.DimmableDevice;

public class DimActionRowFullWidth<D extends DimmableDevice<D>> extends SeekBarActionRowFullWidth<D> {

    public DimActionRowFullWidth(D device, int layoutId) {
        this(device, layoutId, null);
    }

    public DimActionRowFullWidth(D device, int layoutId, TableRow updateRow) {
        super(
                toDimProgress(device.getDimPosition(), device.getDimLowerBound(), device.getDimStep()),
                0,
                toDimProgress(device.getDimUpperBound(), device.getDimLowerBound(), device.getDimStep()),
                layoutId, updateRow);
    }

    public void onStopTrackingTouch(final Context context, D device, int progress) {
        Intent intent = new Intent(Actions.DEVICE_DIM);
        intent.putExtra(BundleExtraKeys.DEVICE_DIM_PROGRESS, progress);
        intent.putExtra(BundleExtraKeys.DEVICE_NAME, device.getName());
        intent.putExtra(BundleExtraKeys.RESULT_RECEIVER, new ResultReceiver(new Handler()) {
            @Override
            protected void onReceiveResult(int resultCode, Bundle resultData) {
                context.sendBroadcast(new Intent(Actions.DO_UPDATE));
            }
        });

        context.startService(intent);
    }

    static int toDimProgress(int progress, int lowerBound, int step) {
        return (progress - lowerBound) / step;
    }

    static int dimProgressToDimState(int progress, int lowerBound, int step) {
        return progress * step + lowerBound;
    }

    @Override
    public String toUpdateText(D device, int progress) {
        int dimProgress = toDimProgress(progress, device.getDimLowerBound(), device.getDimStep());
        return device.getDimStateForPosition(dimProgress);
    }
}
